select nvl(u.f_apply_num, '') CODE,
       nvl(u.f_user_name, '') UNITNAME,
       nvl(u.f_residential_area, '') UNITADDRESS,
       nvl(u.f_contact, '') LINKNAME,
       nvl(u.f_phone, '') LINKTEL,
       nvl(u.f_address, '') GASADDRESS,
       nvl(u.f_operator, '') OPERATORNAME,
       nvl(u.f_apply_date, '') REGDATE,
       nvl(u.f_apply_remarks, '') REMARKS,
       nvl(act.defname, '') STATES,
       nvl(b.CHARGEITEMNAMES, '') CHARGEITEMNAMES,
       nvl(u.f_due_money, '') CONTRACTCOST,
       nvl(u.f_construction_unit, '') NAME
from t_apply u
left join activityins act
on act.processid = u.f_process_id
left join (
    select f_process_id,listagg(f_payment_term, ',') within group(order by f_process_id) CHARGEITEMNAMES
    from (
        select f_process_id,f_payment_term
        from t_charge_record
        group by f_process_id,f_payment_term
    ) a
    group by f_process_id
) b
on u.f_process_id = b.f_process_id
where {condition} and act.state='开始活动'
order by {orderitem}
