select *
from (
     select
         substr(
                 a.f_install_project,
                 instr(a.f_install_project, '"', 1, (b.cnt * 2) -1) + 1,
                 instr(a.f_install_project, '"', 1, b.cnt * 2) - instr(a.f_install_project, '"', 1, (b.cnt * 2) -1) -1
             ) f_install_project,
         a.f_construction_unit,
         a.f_construction_date,
         a.f_apply_num,
         f_user_name
     from
         (
             select
                 f_install_project,
                 f_construction_unit,
                 f_construction_date,
                 f_apply_num,
                 f_user_name,
                 case
                     when f_install_project is null then 0
                     when f_install_project = '[]' then 0
                     else length(f_install_project) - nvl(length(replace(f_install_project, ',')), 0) + 1
                     end cnt
             from t_apply
             where {condition}
         ) a,
         (
             select rownum cnt
             from (
                      select sum(cnt) cnt
                      from (
                               select
                                   case
                                       when f_install_project is null then 0
                                       when f_install_project = '[]' then 0
                                       else length(f_install_project) - nvl(length(replace(f_install_project, ',')), 0) + 1
                                       end cnt
                               from t_apply
                               where {condition}
                           )
                  )
                 connect by level <= cnt
         ) b
     where b.cnt <= a.cnt
) where {
    f_install_project == null || f_install_project == $null$ :
    $1=1$,
    $f_install_project = '{f_install_project}'$
}
