package com.aote.utils;

import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class ReadFile {

    /**
     * 获取传入文件在服务器中的绝对路径（删除文件前的file:）
     * @param file
     * @return
     */
    public String GetResourceURL(String file){
        String path =this.getClass().getClassLoader().getResource(file).getPath();
        if(path.contains("file:")){
            path = path.split("file:")[1];
        }
        return path;
    }


    /**
     * 读取文件内数据为JsonObject
     * @param path
     * @return
     */
    public JSONObject Read(String path){
        File file = new File(path);
        StringBuffer content = new StringBuffer();
        BufferedReader read = null;
        try {
            read = new BufferedReader(new InputStreamReader( new FileInputStream(file), StandardCharsets.UTF_8 ));
            String line;
            while ((line = read.readLine()) != null) {
                content.append(line);
            }
        } catch (FileNotFoundException e) {
            new Exception("文件->"+path+"||||  未找到").printStackTrace();
        } catch (IOException e) {
            new Exception("文件->"+path+"||||  读取异常").printStackTrace();
        }
        String val = content.toString();
        if("".equals(val) || !val.contains("{")){
            return new JSONObject();
        }
        val=val.substring(val.indexOf("{"));
        return new JSONObject(val);
    }

    public static void main(String[] args) {
        Object obj = "12345";
        if(obj instanceof String){
            System.out.println(123);
        }
    }
}
