package com.aote.timerjob;

import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.rs.LogicService;
import com.aote.utils.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Lazy(false)
public class onecode {

    static Logger log = Logger.getLogger(LogicService.class);
    @Autowired
    private static RestTools restTools;
    @Autowired
    private static EntityServer entityServer;
    @Autowired
    private LogicService logicService;

    @Scheduled(cron = "0 0 1,11,16 * * ?")
    public void doJob(){
        log.debug("进入了定时器获取一码通信息");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("获取到的执行配置为---》"+conf.get("onecode"));
        if ((boolean)conf.get("onecode")){
            try {
                log.debug("开始执行");
                JSONObject param = new JSONObject();
                JSONObject header = new JSONObject();
                String url = "http://192.168.10.17:5200/api/jtgk/aod/v1.0/getDataFromOA/getMDMYMTL?api-key=0e0dcf91-5a8d-030e-5afb-acceb11a4db5";
                param.put("ACCESSMETHOD",conf.get("ACCESSMETHOD"));
                param.put("CODE","");
                param.put("TARGETSYS",conf.get("TARGETSYS"));
                header.put("Content-Type","application/json");
                header.put("X-ECC-Current-Tenant","10000");
                String data = restTools.post(url,param,header);
                log.debug(data);
                JSONObject result = new JSONObject(data);
                JSONObject logicparam  = new JSONObject();
                logicparam.put("data",result);
                logicService.xtSave("getOneCode",logicparam.toString());

            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("未配置启动自动下发");
        }
    }
}
