package com.aote.plugins;


import com.af.plugins.DateTools;
import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import org.apache.http.HttpEntity;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AddressImport {
    public final static String XLS = "xls";
    public final static String XLSX = "xlsx";
    static Logger log = Logger.getLogger(AddressImport.class);
    /**
     * 导入用户地址
     * @return 成功导入条数
     * data 本次导入的地址
     */
    public JSONObject importUserAddress(JSONArray data, EntityServer entity, JSONObject user, SqlServer sql) throws Exception {
        long begin = System.currentTimeMillis();
        //当前时间
        String date = DateTools.getNow2();
        //每次保存的地址
        JSONObject saveAddress;
        //获取省市区信息
        HashMap<String, JSONObject> pcdlist=this.getPcdList(sql);

        //获取街道信息
        HashMap<String, JSONObject> streetlist=this.getStreetList(sql);
        //获取小区信息
        HashMap<String, JSONObject> arealist=this.getAreaList(sql);
        int n = 0;
        int success=0;
        for(Object o : data){
            JSONObject json = (JSONObject) o;
            saveAddress = new JSONObject();
            saveAddress.put("f_create_person",user.getString("name"));
            saveAddress.put("f_operator",user.getString("name"));
            saveAddress.put("f_filialeid",user.getString("orgid"));
            saveAddress.put("f_orgid",user.getString("orgid"));
            saveAddress.put("f_orgname",user.getString("orgs"));
            saveAddress.put("f_depid",user.getString("depids"));
            saveAddress.put("f_depname",user.getString("parentname"));
            saveAddress.put("f_operatorid",user.getString("id"));

            JSONObject address = json.getJSONObject("t_user_address");
            //取出数据
            String f_pcd = address.optString("f_pcd");
            String f_street = address.optString("f_street");
            String f_residential_area = address.optString("f_residential_area");
            String f_slice_area = address.optString("f_slice_area");
            Integer f_pcd_id;
            Integer f_street_id;
            Integer f_residential_area_id;
            //省市区暂不新加
            if(pcdlist.containsKey(f_pcd)){
                f_pcd_id=((JSONObject)pcdlist.get(f_pcd)).getInt("id");
            }else {
                f_pcd_id=null;
                JSONObject resurtjson = new JSONObject();
                resurtjson.put("type","warning");
                resurtjson.put("msg",(n+1)+"行数据省市区不存在,导入失败");
                return resurtjson;
            }
            //判断是否有此街道
            if(streetlist.containsKey(f_street)){
                f_street_id=((JSONObject)streetlist.get(f_street)).getInt("id");

            }else {
                JSONObject streetjson = new JSONObject();
                streetjson.put("f_operator",user.getString("name"));
                streetjson.put("f_filialeid",user.getString("orgid"));
                streetjson.put("f_orgid",user.getString("orgid"));
                streetjson.put("f_orgname",user.getString("orgs"));
                streetjson.put("f_depid",user.getString("depids"));
                streetjson.put("f_depname",user.getString("parentname"));
                streetjson.put("f_operatorid",user.getString("id"));
                streetjson.put("f_pcd",f_pcd);
                streetjson.put("f_pcd_id",f_pcd_id);
                streetjson.put("f_street",f_street);
                f_street_id=Integer.parseInt(new JSONObject(entity.partialSave("t_street",streetjson)).getString("id"));
                streetjson.put("id",f_street_id);
                streetjson.put("value",f_street);
                //新增的加入比对队列
                streetlist.put(f_street,streetjson);
            }
            //判断是否有此小区
            if(arealist.containsKey(f_residential_area)){
                f_residential_area_id=((JSONObject)arealist.get(f_residential_area)).getInt("id");
            }else {
                JSONObject areajson = new JSONObject();
                areajson.put("f_operator",user.getString("name"));
                areajson.put("f_filialeid",user.getString("orgid"));
                areajson.put("f_orgid",user.getString("orgid"));
                areajson.put("f_orgname",user.getString("orgs"));
                areajson.put("f_depid",user.getString("depids"));
                areajson.put("f_depname",user.getString("parentname"));
                areajson.put("f_operatorid",user.getString("id"));
                areajson.put("f_pcd",f_pcd);
                areajson.put("f_pcd_id",f_pcd_id);
                areajson.put("f_street",f_street);
                areajson.put("f_street_id",f_street_id);
                areajson.put("f_residential_area",f_residential_area);
                areajson.put("f_area_address",f_pcd+f_street);
                areajson.put("f_slice_area",f_slice_area);
                f_residential_area_id=Integer.parseInt(new JSONObject(entity.partialSave("t_area",areajson)).getString("id"));
                areajson.put("id",f_residential_area_id);
                areajson.put("value",f_residential_area);
                //新增的加入比对队列
                arealist.put(f_residential_area,areajson);
            }
            saveAddress.put("f_pcd_id",f_pcd_id);
            saveAddress.put("f_street_id",f_street_id);
            saveAddress.put("f_residential_area_id",f_residential_area_id);
            saveAddress.put("f_slice_area",f_slice_area);
            String f_building = address.optString("f_building");
            String f_unit = address.optString("f_unit");
            String f_floor = address.optString("f_floor");
            String f_room = address.optString("f_room");
            String f_address = f_pcd+f_street+f_residential_area;
            if(f_building.length()>0){
                String f_building_suffix = "栋";
                saveAddress.put("f_building_suffix",f_building_suffix);
                f_address=f_address+ f_building+f_building_suffix;
            }
            if(f_unit.length()>0){
                String f_unit_suffix = "单元";
                saveAddress.put("f_unit_suffix",f_unit_suffix);
                f_address=f_address+ f_unit+f_unit_suffix;
            }
            if(f_floor.length()>0){
                String f_floor_suffix = "层";
                saveAddress.put("f_floor_suffix",f_floor_suffix);
                f_address=f_address+ f_floor+f_floor_suffix;
            }
            if(f_building.length()>0){
                String f_room_suffix = "室";
                saveAddress.put("f_room_suffix",f_room_suffix);
                f_address=f_room+ f_building+f_room_suffix;
            }
            saveAddress.put("f_pcd",f_pcd);
            saveAddress.put("f_street",f_street);
            saveAddress.put("f_residential_area",f_residential_area);
            saveAddress.put("f_unit",f_unit);
            saveAddress.put("f_room",f_room);
            saveAddress.put("f_floor",f_floor);
            saveAddress.put("f_building",f_building);
            saveAddress.put("f_address",f_address);
            saveAddress.put("f_create_date",date);
            try {
                entity.partialSave("t_user_address",saveAddress);
                success++;
            } catch (WebException e){
                log.warn("插入一条数据异常"+e.getMessage());
            }
            n++;
        }
        long end = System.currentTimeMillis();
        System.out.println("导入"+n+"条,耗时"+(end-begin));
        System.out.println("成功"+success+"条");
        JSONObject resurtjson2 = new JSONObject();
        resurtjson2.put("type","success");
        resurtjson2.put("msg","成功导入"+success+"条");
        return resurtjson2;
    }

    //返回省市区信息
    public  HashMap<String, JSONObject> getPcdList(SqlServer sql)throws Exception{
        HashMap<String, JSONObject> result=new HashMap<String, JSONObject>();
        JSONArray sqldata=sql.query("select * from t_pcd");
        for(Object o : sqldata){
            JSONObject onedata = (JSONObject) o;
            String colunmname=onedata.getString("f_pcd");
            JSONObject json = new JSONObject();
            json.put("id",onedata.getInt("id"));
            json.put("value",colunmname);
            result.put(colunmname,json);
        }
        return result;
    }

    //返回街道信息
    public  HashMap<String, JSONObject> getStreetList(SqlServer sql)throws Exception{
        HashMap<String, JSONObject> result=new HashMap<String, JSONObject>();
        JSONArray sqldata=sql.query("select * from t_street");
        for(Object o : sqldata){
            JSONObject onedata = (JSONObject) o;
            String colunmname=onedata.getString("f_street");
            JSONObject json = new JSONObject();
            json.put("id",onedata.getInt("id"));
            json.put("value",colunmname);
            json.put("f_pcd_id",onedata.getInt("f_pcd_id"));
            json.put("f_pcd",onedata.getString("f_pcd"));
            result.put(colunmname,json);
        }
        return result;
    }

    //返回小区信息
    public  HashMap<String, JSONObject> getAreaList(SqlServer sql)throws Exception{
        HashMap<String, JSONObject> result=new HashMap<String, JSONObject>();
        JSONArray sqldata=sql.query("select * from t_area");
        for(Object o : sqldata){
            JSONObject onedata = (JSONObject) o;
            String colunmname=onedata.getString("f_residential_area");
            JSONObject json = new JSONObject();
            json.put("id",onedata.getInt("id"));
            json.put("value",colunmname);
            json.put("f_pcd_id",onedata.getInt("f_pcd_id"));
            json.put("f_pcd",onedata.getString("f_pcd"));
            json.put("f_street_id",onedata.getInt("f_street_id"));
            json.put("f_street",onedata.getString("f_street"));
            result.put(colunmname,json);
        }
        return result;
    }


    /**
     * 获取excel多少行
     */
    public static int getExcelLine(String filepath){
        List<String[]> data = getExcelData(filepath);
        if(data.size()>0){
            return data.size();
        }
        return 0;
    }

    public static List<String[]> getExcelData(String filepath){
        List<String[]> data = null;
        InputStream is = null;
        try{
            filepath = filepath.replaceAll("\\\\", "/");
            String jsonString = "{\"filepath\":\""+filepath+"\"}";
            HttpEntity httpEntity = RestTools.postHttpEntity("/rs/file/getUploadFile",new JSONObject(jsonString));
            is = httpEntity.getContent();
        }catch(Exception e){
            throw new WebException(500, filepath+"您所选的文件不存在!!!");
        }
        filepath = filepath.replace("\\", "/");
        String fileName = filepath.split("/")[filepath.split("/").length - 1];
        if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
            try {
                data = readExcel(is, fileName);
            } catch (IOException e) {
                throw new WebException(500, "文件解析错误!!!");
            }
        } else {
            throw new WebException(500, "非excel文件暂时未作处理.如有需求,请联系开发人员!!!!");
        }
        return data;
    }

    /**
     * 读入excel文件，解析后返回
     */
    public static List<String[]> readExcel(InputStream is, String fileName) throws IOException {
        // 检查文件
        checkFile(is);
        // 获得Workbook工作薄对象
        Workbook workbook = getWorkBook(is, fileName);
        // 创建返回对象，把每行中的值作为一个数组，所有行作为一个集合返回
        List<String[]> list = new ArrayList<>();
        if (workbook != null) {
            for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); sheetNum++) {
                // 获得当前sheet工作表
                Sheet sheet = workbook.getSheetAt(sheetNum);
                if (sheet == null) {
                    continue;
                }
                // 获得当前sheet的开始行
                int firstRowNum = sheet.getFirstRowNum();
                // 获得当前sheet的结束行
                int lastRowNum = sheet.getLastRowNum();
                if (sheetNum == 0) {
                    firstRowNum = firstRowNum - 1;
                }
                // 循环除了第一行的所有行
                // 列数以第一行为准
                int lastCellNum = 0;
                for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; rowNum++) {
                    // 获得当前行
                    Row row = sheet.getRow(rowNum);
                    if (row == null) {
                        continue;
                    }
                    // 获得当前行的开始列
                    int firstCellNum = row.getFirstCellNum();
                    // 获得当前行的列数
//					int lastCellNum = row.getPhysicalNumberOfCells();
                    if (rowNum == 0) {
                        lastCellNum = row.getPhysicalNumberOfCells();
                    }
                    String[] cells = new String[lastCellNum];
                    // 循环当前行
                    for (int cellNum = firstCellNum; cellNum < lastCellNum; cellNum++) {
                        Cell cell = row.getCell(cellNum);
                        cells[cellNum] = getCellValue(cell);
                    }
                    if (validateCells(cells)) {
                        list.add(cells);
                    }
                }
            }
            workbook.close();
        }
        return list;
    }
    private static void checkFile(InputStream is) throws IOException {
        // 判断文件是否存在
        if (null == is) {
            log.error("文件不存在！");
            throw new FileNotFoundException("文件不存在！");
        }
    }
    private static Workbook getWorkBook(InputStream is, String fileName) {
        //创建Workbook工作薄对象，表示整个excel
        Workbook workbook = null;
        try {
            // 获取excel文件的io流
            //InputStream is = file.getInputStream();
            // 根据文件后缀名不同(xls和xlsx)获得不同的Workbook实现类对象
            if (fileName.endsWith(XLS)) {
                // 2003
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith(XLSX)) {
                // 2007
                workbook = new XSSFWorkbook(is);
            }
        } catch (IOException e) {
            log.info(e.getMessage());
        }
        return workbook;
    }
    public static boolean validateCells (String[] cells) {
        for (String str: cells) {
            if (str != null && !"".equals(str)) {
                return true;
            }
        }
        return false;
    }
    private static String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        // 把数字当成String来读，避免出现1读成1.0的情况
        if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
            cell.setCellType(Cell.CELL_TYPE_STRING);
        }
        // 判断数据的类型
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_NUMERIC: // 数字
                cellValue = String.valueOf(cell.getNumericCellValue());
                break;
            case Cell.CELL_TYPE_STRING: // 字符串
                cellValue = String.valueOf(cell.getStringCellValue());
                break;
            case Cell.CELL_TYPE_BOOLEAN: // Boolean
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            case Cell.CELL_TYPE_FORMULA: // 公式
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            case Cell.CELL_TYPE_BLANK: // 空值
                cellValue = "";
                break;
            case Cell.CELL_TYPE_ERROR: // 故障
                cellValue = "非法字符";
                break;
            default:
                cellValue = "未知类型";
                break;
        }
        return cellValue;
    }

    public static double getValue(String value){
        if(value== null || "".equals(value)){
            return 0;
        }
        Double doubles = new Double(value);
        double ceil= Math.round(doubles);
        return new Double(ceil);
    }


}
