package com.aote.jm.aes;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;

public class SignTempCrypt {
    // 加密解密工具类
    private WXBizMsgCrypt wxBizMsgCrypt;
    private String token ="QDG6eK";
    //密钥
    private String encodingAesKey;
    //appdi
    private String corpId;

    private final String templateencrypt = "<xml><FromUserName><![CDATA[corpId]]></FromUserName><Content><![CDATA[reqstr]]></Content><AgentID>128</AgentID></xml>";
    private final String templaterequestbody = "<xml><ToUserName><![CDATA[corpId]]></ToUserName><Encrypt><![CDATA[reqstr]]></Encrypt><AgentID><![CDATA[218]]></AgentID></xml>";

    /**
     * 构造方法
     * @param token  token
     * @param encodingAesKey  密钥
     * @param corpId  apid
     * @throws AesException
     */
    public SignTempCrypt(String token, String encodingAesKey, String corpId) throws AesException {
        this.token = token;
        this.encodingAesKey = encodingAesKey;
        this.corpId = corpId;
        this.wxBizMsgCrypt = new WXBizMsgCrypt(token,encodingAesKey,corpId);
    }

    /**
     * 构造无需token
     * @param encodingAesKey
     * @param corpId
     * @throws AesException
     */
    public SignTempCrypt(String encodingAesKey, String corpId) throws AesException {
        this.encodingAesKey = encodingAesKey;
        this.corpId = corpId;
        this.wxBizMsgCrypt = new WXBizMsgCrypt(token,encodingAesKey,corpId);
    }

    /**
     * 加密数据
     * @param param
     * @param timeStamp
     * @param nonce
     * @return
     */
    public String encrypt(JSONObject param, String timeStamp,String nonce) throws Exception {
        String resultstr = "";
        if( StringUtils.isEmpty(timeStamp) && StringUtils.isEmpty(nonce) ) return resultstr;
        if(param == null || param.isEmpty()) return resultstr;
        if(this.wxBizMsgCrypt == null) throw new Exception("请先初始化");
        resultstr = wxBizMsgCrypt.EncryptMsg(JsontoXml(param.toString()), timeStamp, nonce);
        return resultstr;
    }

    /**
     * 获取请求的 请求体
     * @param param  加密后的xml
     * @return  请求体
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws SAXException
     */
    public String getRestBody(String param) throws Exception {
        if(StringUtils.isEmpty(param)) throw new Exception("密文xml为空或者不存在");
        String encrypt = toxml(param, "Encrypt");
        String body = templaterequestbody;
        body = body.replaceAll("corpId", this.corpId);
        body = body.replaceAll("reqstr",encrypt);
        return body;
    }

    /**
     * 获取请求头
     * @param param
     * @return
     * @throws Exception
     */
    public JSONObject getRestHeader(String param) throws Exception {
        if(StringUtils.isEmpty(param)) throw new Exception("密文xml为空或者不存在");
        JSONObject resultobj = new JSONObject();
        try {
            resultobj.put("msg_signature",toxml(param,"MsgSignature"));
            resultobj.put("timestamp",toxml(param,"TimeStamp"));
            resultobj.put("nonce",toxml(param,"Nonce"));
        } catch (Exception e) {
            throw new Exception("xml解析失败");
        }
        return resultobj;
    }

    /**
     * 获取将请求拼接url字符串
     * @param param
     * @return
     * @throws Exception
     */
    public String getRestHeader2(String param) throws Exception {
        if(StringUtils.isEmpty(param)) throw new Exception("密文xml为空或者不存在");
        JSONObject restHeader = getRestHeader(param);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = restHeader.keys();
        while(iterator.hasNext()){
            String key = iterator.next();
            stringBuilder.append(key);
            stringBuilder.append("=");
            stringBuilder.append(restHeader.get(key));
            if(iterator.hasNext()){
                stringBuilder.append("&");
            }
        }
        return stringBuilder.toString();
    }


    /**
     * 加密数据
     * @param respStr
     * @param sign
     * @param timeStamp
     * @param nonce
     * @return
     * @throws Exception
     */
    public JSONObject decrypt(String respStr,String sign,String timeStamp,String nonce) throws Exception {
        JSONObject resultobj = new JSONObject();
        if(StringUtils.isEmpty(respStr) && StringUtils.isEmpty(timeStamp) && StringUtils.isEmpty(nonce) && StringUtils.isEmpty(sign) ) return resultobj;
        try {
            String sMsg = wxBizMsgCrypt.DecryptMsg(sign, timeStamp, nonce, respStr);
            String content = toxml(sMsg, "Content");
            resultobj = new JSONObject(content);
        } catch (AesException e) {
            throw new Exception("验证签名失败");
        }
        return resultobj;
    }

    /**
     * 将json拼接为xml
     * @param param
     * @return
     */
    public String JsontoXml(String param){
        if(StringUtils.isEmpty(param)) return "";
        String sRespData = templateencrypt;
        sRespData = sRespData.replaceAll("corpId", this.corpId);
        sRespData = sRespData.replaceAll("reqstr",param);
        return sRespData;
    }

    /**
     * 通过xml中的标签名获取其中text, 用户获取sign,时间戳等
     * @param param
     * @param key
     * @return
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public String toxml(String param,String key) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        StringReader sr = new StringReader(param);
        InputSource is = new InputSource(sr);
        Document document = db.parse(is);
        Element root= document.getDocumentElement();
        //获取生成xml中的签名
        NodeList nodelist1 = root.getElementsByTagName(key);
        return  nodelist1.item(0).getTextContent();
    }

}
