-- 公共SQL：获取用户除本次外最近的充值或冲正情况（适用V3）
-- 必选参数
-- userId：表档案编号
-- times：充值记录次数

SELECT
    -- 充值序号
    sell.id,
    -- 充值金额
    sell.payvalue,
    -- 充值时间
    sell.date,
    -- 充值次数
    sell.f_times
FROM (
         SELECT
             f.id             id,
             f.f_userfiles_id userId,
             f.f_preamount    payvalue,
             f.f_times        f_times,
             f.f_operate_date date,
             f.f_sendsuccess
         FROM t_fillgas f
         WHERE f.f_state = '有效'
         UNION ALL
         SELECT
             s.id             id,
             s.f_userfiles_id userId,
             case s.f_type
                 when '退费' then s.f_collection
                 else s.f_preamount
                 end          payvalue,
             s.f_times        f_times,
             s.f_operate_date date,
             s.f_sendsuccess
         FROM t_sellinggas s
         WHERE s.f_state = '有效'
           AND s.f_type IN ('物联网收费', '退费')
         UNION ALL
         SELECT s.id             id,
                s.f_userfiles_id userid,
                s.f_preamount    payValue,
                s.f_times        f_times,
                s.f_operate_date date,
                s.f_sendsuccess
         FROM t_sellinggas s
                  LEFT JOIN t_sellinggas tsp ON s.f_old_sell_id = tsp.id
         WHERE s.f_state = '撤销'
           AND tsp.f_type IN ('物联网收费', '退费')
           AND tsp.f_sendsuccess = '成功'
     ) sell
WHERE sell.userId = '{userId}' AND sell.f_sendsuccess = '成功' AND sell.f_times < '{times}'
ORDER BY sell.f_times DESC
