/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.stair;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

public class DateProcess {
    public boolean isAfter(String date, Integer add, String forMate) {
        if (date == null || add == null) {
            return false;
        }
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.now().isAfter(parse.plusMonths(add.intValue()));
    }

    public boolean isAfter(String oneDate, String twoDate) {
        if (oneDate.length() > 19) {
            oneDate = oneDate.substring(0, 19);
        }
        if (twoDate.length() > 10) {
            twoDate = twoDate.substring(0, 10);
        }
        DateTimeFormatter df1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter df2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate one = LocalDateTime.parse(oneDate, df1).toLocalDate();
        LocalDate two = LocalDate.parse(twoDate, df2);
        return one.isAfter(two);
    }

    public int getOne(String date, String key) {
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        LocalDateTime dateTime = LocalDateTime.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        int res = -1;
        switch (key) {
            case "year": {
                res = dateTime.getYear();
                break;
            }
            case "month": {
                res = dateTime.getMonthValue();
                break;
            }
            case "day": {
                res = dateTime.getDayOfMonth();
                break;
            }
            case "hour": {
                res = dateTime.getHour();
                break;
            }
            case "minute": {
                res = dateTime.getMinute();
                break;
            }
            case "second": {
                res = dateTime.getSecond();
                break;
            }
            default: {
                res = -1;
            }
        }
        return res;
    }

    public String addDate(String date, Integer add, String forMate) {
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return parse.plusMonths(add.intValue()).format(dtf);
    }

    public boolean isDoIt(String date, String period, String forMate) {
        if (date == null || period == null) {
            return false;
        }
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        LocalDateTime now = LocalDateTime.now();
        parse = parse.plusMonths(Integer.parseInt(period));
        return now.getYear() == parse.getYear() && now.getMonth() == parse.getMonth() && now.getDayOfMonth() == parse.getDayOfMonth();
    }

    public String getNowMonthFirst() {
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getNowMonthLast() {
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getYesterdayMonthFirst() {
        return LocalDateTime.of(LocalDateTime.now().plusDays(-1L).with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getYesterdayMonthLast() {
        return LocalDateTime.of(LocalDateTime.now().plusDays(-1L).with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getMonthFirst(String date) {
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getMonthLast(String date) {
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String yearMonthFormatterDate(String date) {
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM");
        DateTimeFormatter ove = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDate.parse(date, dtf).atStartOfDay();
        return parse.format(ove);
    }

    public String getTodayStart() {
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    public String getTodayEnd() {
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    public String getYesterdayStart() {
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now().plusDays(-1L), LocalTime.MIN);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    public String getYesterdayEnd() {
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now().plusDays(-1L), LocalTime.MAX);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    public String now() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(LocalDateTime.now());
    }

    public String getNowYearStart() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate firstDayOfYear = LocalDate.now().with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime firstDateOfYear = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return df.format(firstDateOfYear);
    }

    public String getNowYearEnd() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate lastDayOfYear = LocalDate.now().with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime lastDateOfYear = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return df.format(lastDateOfYear);
    }

    public String getYesterdayYearStart() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate firstDayOfYear = LocalDate.now().plusDays(-1L).with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime firstDateOfYear = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return df.format(firstDateOfYear);
    }

    public String getYesterdayYearEnd() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate lastDayOfYear = LocalDate.now().plusDays(-1L).with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime lastDateOfYear = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return df.format(lastDateOfYear);
    }

    public String getYearStart(String date) {
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, df);
        LocalDate firstDayOfYear = parse.toLocalDate().with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime firstDateOfYear = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return df.format(firstDateOfYear);
    }

    public String getYearEnd(String date) {
        if (date.length() > 19) {
            date = date.substring(0, 19);
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, df);
        LocalDate lastDayOfYear = parse.toLocalDate().with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime lastDateOfYear = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return df.format(lastDateOfYear);
    }
}

