package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 模块
 *
 * @author Mr.river
 */
public enum ModuleEnum {

    //公共模块
    PUBLIC_MODULE("webmeter");

    private final String value;

    ModuleEnum(String value) {
        this.value = value;
    }

    public static ModuleEnum toType(String value) {
        return Stream.of(ModuleEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
