package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 数据源类型
 * @author Mr.river
 */
public enum DataSourceTypeEnum {

    //SqlServer
    SQLSERVER("SqlServer"),
    //Oracle
    ORACLE("Oracle"),
    //MySQL
    MYSQL("MySQL");

    private final String value;

    DataSourceTypeEnum(String value) {
        this.value = value;
    }

    public static DataSourceTypeEnum toType(String value) {
        return Stream.of(DataSourceTypeEnum.values())
                .filter(p -> p.value.equalsIgnoreCase(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
