/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.service;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ResCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResCheckService.class);
    private static final List<String> ERROR_ARRAY = new ArrayList<String>();
    private static final String[] sentence = new String[]{"\u8f6f\u4ef6\u5f00\u53d1\u5f80\u5f80\u662f\u8fd9\u6837\uff1a\u6700\u5f00\u59cb\u768490%\u4ee3\u7801\u5360\u7528\u4e86\u5f00\u59cb\u768490%\u7684\u5f00\u53d1\u65f6\u95f4\uff1b\u5269\u4e0b10%\u4ee3\u7801\u540c\u6837\u9700\u898190%\u7684\u5f00\u53d1\u65f6\u95f4\u3002", "\u8fd9\u4e0d\u662f\u4e00\u4e2abug\uff0c\u8fd9\u53ea\u662f\u4e00\u4e2a\u672a\u5217\u51fa\u6765\u7684\u7279\u6027\u3002", "\u4f5c\u4e3a\u4e00\u4e2a\u7a0b\u5e8f\u5458\uff0c\u90c1\u95f7\u7684\u4e8b\u60c5\u662f\uff0c\u2faf\u5bf9\u4e00\u4e2a\u4ee3\u7801\u5757\uff0c\u5374\u4e0d\u6562\u53bb\u4fee\u6539\u3002\u66f4\u7cdf\u7cd5\u7684\u662f\uff0c\u8fd9\u4e2a\u4ee3\u7801\u5757\u8fd8\u662f\u2f83\u2f30\u5199\u7684\u3002", "\u5728\u7cfb\u7edf\u6d4b\u8bd5\u9636\u6bb5\u67e5\u627e\u5e76\u4fee\u590d Bug\uff0c\u82b1\u8d39\u7684\u65f6\u95f4\u548c\u5de5\u4f5c\u91cf\u662f\u8ba9\u5f00\u53d1\u8005\u81ea\u5df1\u627e Bug \u7684\u4e09\u500d\u3002\u5728\u6b63\u5f0f\u4e0a\u7ebf\u540e\u67e5\u627e\u5e76\u4fee\u590d Bug\uff0c\u82b1\u8d39\u7684\u65f6\u95f4\u548c\u5de5\u4f5c\u91cf\u662f\u7cfb\u7edf\u6d4b\u8bd5\u9636\u6bb5\u7684\u5341\u500d\u3002\u56e0\u6b64\u4e00\u5b9a\u8981\u8ba9\u5f00\u53d1\u8005\u81ea\u5df1\u505a\u5355\u5143\u6d4b\u8bd5\u3002", "\u4e0d\u8981\u7ad9\u7740\u8c03\u8bd5\u3002\u7ad9\u7740\u4f1a\u8ba9\u4f60\u7684\u8010\u5fc3\u51cf\u534a\uff0c\u800c\u4e14\u4f60\u9700\u8981\u96c6\u4e2d\u6240\u6709\u7cbe\u529b\u3002", "\u6d4b\u8bd5\u53ef\u4ee5\u53d1\u73b0bug\u7684\u5b58\u5728\uff0c\u4f46\u4e0d\u80fd\u8bc1\u660ebug\u4e0d\u5b58\u5728\u3002", "\u65b0\u7cfb\u7edf\u7684\u6bcf\u4e2a\u65b0\u7528\u6237\u90fd\u4f1a\u53d1\u73b0\u4e00\u7c7b\u65b0\u7684Bug\u3002", "\u4fee\u590d\u635f\u574f\u7684\u7a0b\u5e8f\u7684\u7b2c\u4e00\u6b65\u5c31\u662f\u8ba9\u5b83\u4e0d\u65ad\u5931\u8d25\u3002", "\u6709\u4e24\u79cd\u65b9\u6cd5\u80fd\u5199\u51fa\u6ca1\u6709\u9519\u8bef\u7684\u7a0b\u5e8f\uff1b\u4f46\u53ea\u6709\u7b2c\u4e09\u79cd\u597d\u7528\u3002", "\u6700\u5371\u9669\u7684\u662f\uff1a\u4f60\u5199\u7684\u4ee3\u7801\u516d\u4e2a\u6708\u540e\u81ea\u5df1\u90fd\u770b\u4e0d\u61c2\u3002", "\u7a0b\u5e8f\u5458\u7684\u4e09\u5927\u8c0e\u8a00\uff1a\u8fd9\u662f\u4e2a\u7b80\u5355\u7684\u6539\u52a8\uff1b\u8fd9\u4e2abug\u6211\u4fee\u597d\u4e86\uff1b\u4ee3\u7801\u5199\u5b8c\u4e86\u3002", "\u5199\u4ee3\u7801\u8981\u50cf\u5199\u60c5\u4e66\u4e00\u6837\u4f18\u96c5\uff0c\u8981\u50cf\u5199\u9057\u5631\u4e00\u6837\u4e25\u8c28\u3002", "\u4ee3\u7801\u5199\u7684\u8d8a\u6025\uff0c\u7a0b\u5e8f\u8dd1\u5f97\u8d8a\u6162\u3002"};
    private static final String[] prompt = new String[]{"\u6211\u4eec\u6709\u8fc7\u5404\u79cd\u521b\u4f24\uff0c\u4f46\u6211\u4eec\u4eca\u5929\u5e94\u8be5\u5feb\u6d3b\u3002", "\u56db\u5904\u8d70\u8d70\uff0c\u4f60\u4f1a\u70ed\u7231\u8fd9\u4e2a\u4e16\u754c\u3002", "\u4e00\u5b9a\u8981\u7231\u7740\u70b9\u4ec0\u4e48\uff0c\u5b83\u8ba9\u6211\u4eec\u53d8\u5f97\u575a\u97e7\u3001\u5bbd\u5bb9\u3001\u5145\u76c8\u3002\u4e1a\u4f59\u7684\uff0c\u7231\u7740\u3002", "\u4e00\u5929\u665a\u4e0a\uff0c\u94fa\u5b50\u90fd\u5173\u4e86\uff0c\u8857\u4e0a\u5df2\u65ad\u884c\u4eba\uff0c\u8def\u706f\u7167\u7740\u7a7a\u8361\u8361\u7684\u9a6c\u8def\uff0c\u800c\u8fdc\u8fdc\u7684\u4e00\u4e2a\u7406\u53d1\u5e97\u6807\u8bb0\u5728\u51b7\u9759\u4e4b\u4e2d\u5b64\u96f6\u96f6\u5730\u52a8\u3002\u8fd9\u4e00\u4e0b\u5b50\u628a\u4f60\u8ddf\u4e16\u754c\u62c9\u5f97\u5f88\u8fd1\uff0c\u72b9\u5982\u5927\u6f20\u5b64\u70df\u3002", "\u6d3b\u7740\uff0c\u5c31\u8fd8\u5f97\u505a\u4e00\u70b9\u4e8b\u3002 \u6211\u4eec\u6709\u8fc7\u5404\u79cd\u521b\u4f24\uff0c\u4f46\u6211\u4eec\u4eca\u5929\u5e94\u8be5\u5feb\u6d3b\u3002", "\u54ea\u91cc\u6709\u9c9c\u82b1\uff0c\u5c31\u5230\u54ea\u91cc\u53bb\u3002", "\u8d70\u5728\u8def\u4e0a\uff0c\u95f4\u6216\u4e5f\u80fd\u89c1\u4e00\u4e2a\u9489\u7897\u7684\uff0c\u4e4b\u6545\u4e4b\u6545\u62c9\u4ed6\u7684\u91d1\u521a\u94bb\uff1b\u4e00\u4e2a\u8865\u9505\u7684\uff0c\u7528\u4e00\u4e2a\u5e03\u5377\u5728\u7070\u4e0a\u4e00\u63c9\uff0c\u6258\u8d77\u4e00\u5c0f\u52fa\u6bb7\u7ea2\u7684\u7194\u94c1\uff0c\u55e4\u5730\u4e00\u58f0\u710a\u5728\u4e00\u53e3\u4e09\u773c\u7076\u5927\u9ed1\u9505\u4e0a\uff1b\u4e00\u4e2a\u76ae\u5320\uff0c\u628a\u5200\u5728\u4ed6\u7684\u8111\u540e\u53d1\u6869\u5b50\u4e0a\u5149\u4e00\u5149\uff0c\u8fd9\u53ef\u4ee5\u8ba9\u4f60\u770b\u534a\u5929\u3002 \u4f60\u770b\u4ed6\u4eec\u5de5\u4f5c\uff0c\u4e5f\u770b\u4ed6\u4eec\u4eba\u3002\u4ed6\u4eec\u662f\u4e00\u79cd\u201c\u9057\u6c11\u201d\uff0c\u6c38\u8fdc\u56fa\u6267\u800c\u6c89\u9ed8\u5730\u6162\u6162\u5730\u8d70\uff0c\u8ba9\u4f60\u89c9\u5f97\u8bb8\u591a\u4e8b\u60c5\u503c\u5f97\u6df1\u601d\u3002", "\u6211\u4e0d\u662f\u4e0d\u98df\u4eba\u95f4\u70df\u706b\uff0c\u4e0d\u61c2\u611f\u60c5\u7684\u4eba\u3002\u6211\u4e0d\u559c\u6b22\u90a3\u79cd\u53e3\u4e0d\u81e7\u5426\u4eba\u7269\uff0c\u7edd\u4e0d\u8bae\u8bba\u671d\u653f\uff0c\u65e0\u7231\u65e0\u618e\uff0c\u65e0\u662f\u65e0\u975e\uff0c\u80c6\u5c0f\u6015\u4e8b\uff0c\u9664\u4e86\u732a\u8089\u767d\u83dc\u7684\u4ef7\u683c\u4ec0\u4e48\u4e5f\u4e0d\u5173\u5fc3\u7684\u79bb\u9000\u4f11\u5e72\u90e8\u3002\u8fd9\u79cd\u4eba\u6709\u7684\u662f\u3002 \u4e2d\u56fd\u4eba\u6709\u4e00\u79cd\u54f2\u5b66\uff0c\u53eb\u505a\u201c\u5fcd\u201d\u3002\u6211\u5c0f\u65f6\u5019\u542c\u8fc7\u201c\u767e\u5fcd\u5802\u201d\u5f20\u5bb6\u7684\u6545\u4e8b\uff0c\u5c31\u975e\u5e38\u8ba8\u538c\u3002\u73b0\u5728\u4e00\u4e9b\u540d\u80dc\u53e4\u8ff9\u5356\u7891\u5e16\u7684\u6587\u7269\u5546\u5e97\u5356\u7684\u4e66\u6cd5\u62d3\u672c\u6700\u591a\u7684\u4e00\u662f\u90d1\u677f\u6865\u7684\u201c\u96be\u5f97\u7cca\u6d82\u201d\uff0c\u4e8c\u662f\u4e00\u4e2a\u5927\u5b57\uff1a\u201c\u5fcd\u201d\u3002\u8fd9\u662f\u4e00\u79cd\u975e\u5e38\u5eb8\u4fd7\u7684\u4eba\u751f\u54f2\u5b66\u3002", "\u4eba\u4e0d\u7ba1\u8d70\u5230\u54ea\u4e00\u6b65\uff0c\u603b\u5f97\u627e\u70b9\u4e50\u5b50\uff0c\u60f3\u4e00\u70b9\u529e\u6cd5\uff0c\u8001\u662f\u6101\u7709\u82e6\u8138\u7684\uff0c\u5e72\u5417\u5462\uff1f", "\u5199\u5b57\u4f5c\u753b\uff0c\u9996\u5148\u5f97\u6709\u6fc0\u60c5\u3002\u8981\u6709\u60c5\u7eea\uff0c\u4e3a\u4e00\u4eba\u3001\u4e00\u4e8b\u3001\u4e00\u6735\u82b1\u3001\u4e00\u7247\u8272\u5f69\u611f\u52a8\u3002\u6709\u4e00\u79cd\u610f\u5411\u3001\u4e00\u56e2\u5174\u81f4\uff0c\u52c3\u52c3\u7136\u90c1\u79ef\u4e8e\u80f8\uff0c\u52bf\u6b32\u55b7\u5410\u800c\u51fa\u3002", "\u6211\u5728\u9999\u6e2f\u65f6\u5168\u50cf\u4e00\u6839\u843d\u5728\u6ce5\u6c34\u91cc\u7684\u9e21\u6bdb\uff0c\u6ca1\u6709\u8bdd\u8bf4\uff0c\u6211\u6cbe\u6e7f\u4e86\uff0c\u5f04\u810f\u4e86\uff0c\u4e0d\u6210\u6837\u5b50\u3002\u5fe7\u90c1\uff0c\u4e00\u79cd\u6beb\u65e0\u610f\u4e49\u7684\u5fe7\u90c1\u3002\u6211\u4e00\u5b9a\u975e\u5e38\u4e11\uff0c\u6211\u8138\u4e0a\u7ebf\u6761\u96f6\u4e71\u829c\u6742\uff0c\u6211\u52a8\u4f5c\u840e\u9761\u9119\u964b\uff0c\u6211\u4e0d\u8ddf\u4eba\u8bf4\u8bdd\uff0c\u6211\u82e5\u4e00\u5f00\u53e3\u4e00\u5b9a\u4e0d\u77e5\u6240\u4e91\uff01\u6211\u771f\u4e0d\u77e5\u9053\u6211\u600e\u4e48\u628a\u81ea\u5df1\u7cdf\u8e4b\u5230\u8fd9\u79cd\u5730\u6b65\u3002", "\u5199\u5b57\u4f5c\u753b,\u9996\u5148\u5f97\u6709\u6fc0\u60c5\u3002\u8981\u6709\u60c5\u7eea,\u4e3a\u4eba\u3001\u4e00\u4e8b\u3001\u4e00\u6735\u82b1\u3001\u4e00\u7247\u8272\u5f69\u611f\u52a8\u3002\u6709\u79cd\u610f\u5411\u3001\u4e00\u56e2\u5174\u81f4,\u52c3\u52c3\u7136\u90c1\u79ef\u4e8e\u80f8,\u52bf\u6b32\u55b7\u5410\u800c\u51fa\u3002\u7231,\u662f\u4e00\u4ef6\u975e\u4e13\u4e1a\u7684\u4e8b\u60c5,\u4e0d\u662f\u672c\u4e8b,\u4e0d\u662f\u80fd\u529b,\u662f\u82b1\u6728\u90a3\u6837\u7684\u751f\u957f,\u6709\u4e00\u4efd\u5bf9\u5149\u9634\u548c\u5b63\u8282\u7684\u949f\u60c5\u548c\u6267\u7740\u3002\u4e00\u5b9a\u8981,\u7231\u7740\u70b9\u4ec0\u4e48,\u5b83\u8ba9\u6211\u4eec\u53d8\u5f97\u575a\u97e7,\u5bbd\u5bb9,\u5145\u76c8\u3002\u4e1a\u4f59\u7740\uff0c\u7231\u7740\u3002", "\u9e1f\u4e3a\u4ec0\u4e48\u8981\u201c\u905b\u201d\uff1f\u4e0d\u905b\u4e0d\u53eb\u3002\u9e1f\u5fc5\u987b\u4e60\u60ef\u4e8e\u7b3c\u517b\uff0c\u4e60\u60ef\u4e8e\u55a7\u95f9\u6270\u6518\u7684\u73af\u5883\u3002\u7b49\u5230\u5b83\u4e60\u60ef\u4e8e\u4e0e\u4eba\u76f8\u5904\u65f6\uff0c\u5b83\u5c31\u4f1a\u5c3d\u60c5\u9e23\u53eb\u3002", "\u8bb0\u5f97\u65e7\u65f6\u597d\uff0c\u8ddf\u968f\u7239\u7239\u53bb\u5403\u8336\u3002\u95e8\u524d\u78e8\u87ba\u58f3\uff0c\u5df7\u53e3\u5f04\u6ce5\u6c99\u3002", "\u5728\u4eba\u751f\u7684\u6bcf\u4e2a\u9636\u6bb5\uff0c\u6211\u4eec\u90fd\u5bf9\u6f2b\u6f2b\u524d\u7a0b\u62b1\u7740\u4e00\u4efd\u6fc0\u52a8\u7684\u5e0c\u671b\uff0c\u4ee5\u4e3a\u5947\u8ff9\u5c31\u5728\u524d\u65b9\u3002\u7136\u800c\uff0c\u4eba\u751f\u53ea\u662f\u4e00\u4e2a\u4e2a\u68a6\u60f3\u4e0d\u65ad\u7834\u706d\u7684\u8fc7\u7a0b\u3002\u800c\u5f53\u6211\u4eec\u8d70\u51fa\u6240\u6709\u66f2\u6298\u7684\u65e5\u5b50\u65f6\u624d\u53d1\u73b0\uff0c\u771f\u6b63\u7684\u7f8e\u597d\u4e0e\u795e\u5947\uff0c\u5df2\u7ecf\u6c38\u8fdc\u5730\u7559\u5728\u4e86\u80cc\u540e\u3002", "\u4f46\u662f\u592a\u9633\uff0c\u4ed6\u6bcf\u65f6\u6bcf\u523b\u90fd\u662f\u5915\u9633\u4e5f\u90fd\u662f\u65ed\u65e5\u3002\u5f53\u4ed6\u7184\u706d\u7740\u8d70\u4e0b\u5c71\u53bb\u6536\u5c3d\u82cd\u51c9\u6b8b\u7167\u4e4b\u9645\uff0c\u6b63\u662f\u4ed6\u5728\u53e6\u4e00\u9762\u71c3\u70e7\u7740\u722c\u4e0a\u5c71\u5dc5\u5e03\u6563\u70c8\u70c8\u671d\u8f89\u4e4b\u65f6\u3002", "\u90a3\u4e00\u5929\uff0c\u6211\u4e5f\u5c06\u6c89\u9759\u7740\u8d70\u4e0b\u5c71\u53bb\uff0c\u6276\u7740\u6211\u7684\u62d0\u6756\u3002\u6709\u4e00\u5929\uff0c\u5728\u67d0\u4e00\u5904\u5c71\u6d3c\u91cc\uff0c\u52bf\u5fc5\u4f1a\u8dd1\u4e0a\u6765\u4e00\u4e2a\u6b22\u8e66\u7684\u5b69\u5b50\uff0c\u62b1\u7740\u4ed6\u7684\u73a9\u5177\u3002\u5f53\u7136\uff0c\u90a3\u4e0d\u662f\u6211\u3002\u4f46\u662f\uff0c\u90a3\u4e0d\u662f\u6211\u5417\uff1f", "\u90a3\u4e00\u5929\u6211\u4e8c\u5341\u4e00\u5c81\uff0c\u5728\u6211\u4e00\u751f\u7684\u9ec4\u91d1\u65f6\u4ee3\uff0c\u6211\u6709\u597d\u591a\u5962\u671b\u3002\u6211\u60f3\u7231\uff0c\u60f3\u5403\uff0c\u8fd8\u60f3\u5728\u4e00\u77ac\u95f4\u53d8\u6210\u5929\u4e0a\u534a\u660e\u534a\u6697\u7684\u4e91\u3002", "\u751f\u6d3b\u5c31\u662f\u4e2a\u7f13\u6162\u53d7\u9524\u7684\u8fc7\u7a0b\uff0c\u4eba\u4e00\u5929\u5929\u8001\u4e0b\u53bb\uff0c\u5962\u671b\u4e5f\u4e00\u5929\u5929\u6d88\u5931\uff0c\u6700\u540e\u53d8\u5f97\u50cf\u6328\u4e86\u9524\u7684\u725b\u4e00\u6837\u3002", "\u56f4\u5728\u57ce\u91cc\u7684\u4eba\u60f3\u9003\u51fa\u6765\uff0c\u57ce\u5916\u7684\u4eba\u60f3\u51b2\u8fdb\u53bb\u3002\u5bf9\u4e8e\u5a5a\u59fb\u4e5f\u7f62\uff0c\u804c\u4e1a\u4e5f\u7f62\uff0c\u4eba\u751f\u7684\u613f\u671b\u5927\u90fd\u5982\u6b64\u3002", "\u6bcf\u4e2a\u4eba\u90fd\u6709\u5c5e\u4e8e\u81ea\u5df1\u7684\u4e00\u7247\u68ee\u6797\uff0c\u8ff7\u5931\u7684\u4eba\u8ff7\u5931\u4e86\uff0c\u76f8\u9022\u7684\u4eba\u4f1a\u518d\u76f8\u9022\u3002", "\u5b64\u72ec\u4e00\u4eba\u4e5f\u6ca1\u5173\u7cfb\uff0c\u53ea\u8981\u80fd\u53d1\u81ea\u5185\u5fc3\u5730\u7231\u7740\u4e00\u4e2a\u4eba\uff0c\u4eba\u751f\u5c31\u4f1a\u6709\u6551\u3002", "\u6240\u8c13\u6d3b\u7740\u5e76\u4e0d\u662f\u5355\u7eaf\u7684\u547c\u5438\uff0c\u5fc3\u810f\u8df3\u52a8\uff0c\u800c\u662f\u5728\u8fd9\u4e2a\u4e16\u754c\u4e0a\u7559\u4e0b\u75d5\u8ff9\u3002", "\u4e16\u754c\u4e0a\u6ca1\u6709\u4e00\u6761\u9053\u8def\u662f\u91cd\u590d\u7684\uff0c\u4e5f\u6ca1\u6709\u4e00\u4e2a\u4eba\u751f\u662f\u53ef\u4ee5\u66ff\u4ee3\u7684\u3002", "\u5351\u9119\u662f\u5351\u9119\u8005\u7684\u901a\u884c\u8bc1\uff0c\u9ad8\u5c1a\u662f\u9ad8\u5c1a\u8005\u7684\u5893\u5fd7\u94ed\u3002", "\u4e61\u6101\u662f\u4e00\u679a\u5c0f\u5c0f\u7684\u90ae\u7968\uff0c\u6211\u5728\u8fd9\u5934\uff0c\u6bcd\u4eb2\u5728\u90a3\u5934\u3002", "\u4ece\u524d\u7684\u65e5\u8272\u53d8\u5f97\u6162\uff0c\u8f66\uff0c\u9a6c\uff0c\u90ae\u4ef6\u90fd\u6162\uff0c\u4e00\u751f\u53ea\u591f\u7231\u4e00\u4e2a\u4eba\u3002", "\u751f\u6d3b\u4e0d\u6b62\u773c\u524d\u7684\u82df\u4e14\uff0c\u8fd8\u6709\u8bd7\u548c\u8fdc\u65b9\u7684\u7530\u91ce\u3002", "\u5982\u679c\u6709\u6765\u751f\uff0c\u8981\u505a\u4e00\u68f5\u6811\uff0c\u7ad9\u6210\u6c38\u6052\uff0c\u6ca1\u6709\u60b2\u6b22\u7684\u59ff\u52bf\u3002", "\u5c81\u6708\u6781\u7f8e\uff0c\u5728\u4e8e\u5b83\u5fc5\u7136\u6d41\u901d\u3002\u6625\u82b1\uff0c\u79cb\u6708\uff0c\u590f\u65e5\uff0c\u51ac\u96ea\u3002", "\u4eba\u6d3b\u4e00\u4e16\uff0c\u8349\u6728\u4e00\u79cb\uff0c\u65e0\u8bba\u957f\u77ed\uff0c\u603b\u5f97\u6709\u4e9b\u610f\u601d\u3002", "\u4e0d\u8981\u56e0\u4e3a\u8d70\u5f97\u592a\u8fdc\uff0c\u800c\u5fd8\u8bb0\u4e3a\u4ec0\u4e48\u51fa\u53d1\u3002", "\u4eba\u751f\u5982\u9006\u65c5\uff0c\u6211\u4ea6\u662f\u884c\u4eba\u3002", "\u4f60\u77e5\u9053\u7684\u8d8a\u591a\uff0c\u4f60\u4e0d\u77e5\u9053\u7684\u8d8a\u591a\u3002", "\u77e5\u6211\u8005\u8c13\u6211\u5fc3\u5fe7\uff0c\u4e0d\u77e5\u6211\u8005\u8c13\u6211\u4f55\u6c42\u3002", "\u751f\u6d3b\u662f\u5f88\u597d\u73a9\u7684\uff0c\u5b83\u4f1a\u5e26\u6765\u5f88\u591a\u60ca\u559c\uff0c\u4e5f\u4f1a\u6709\u4e9b\u5931\u843d\uff0c\u4f46\u65e0\u8bba\u5982\u4f55\uff0c\u90fd\u8981\u8d70\u4e0b\u53bb\u3002", "\u71d5\u5b50\u53bb\u4e86\uff0c\u6709\u518d\u6765\u7684\u65f6\u5019\uff1b\u6768\u67f3\u67af\u4e86\uff0c\u6709\u518d\u9752\u7684\u65f6\u5019\uff1b\u6843\u82b1\u8c22\u4e86\uff0c\u6709\u518d\u5f00\u7684\u65f6\u5019\uff0c\u4f46\u662f\u806a\u660e\u7684\uff0c\u4f60\u544a\u8bc9\u6211\uff0c\u6211\u4eec\u7684\u65e5\u5b50\u4e3a\u4ec0\u4e48\u4e00\u53bb\u4e0d\u590d\u8fd4\u5462\uff1f"};
    private final ApplicationService applicationService;
    private final List<AbstractResourceMapper<?>> abstractResourceMappers;

    public ResCheckService(ApplicationService applicationService, List<AbstractResourceMapper<?>> abstractResourceMappers) {
        this.applicationService = applicationService;
        this.abstractResourceMappers = abstractResourceMappers;
    }

    @PostConstruct
    public void checkAll() {
        EnvType envType = this.applicationService.getEnvType();
        if (envType == EnvType.PROD) {
            LOGGER.info("==================\u8df3\u8fc7\u8d44\u6e90\u68c0\u67e5==================");
            return;
        }
        LOGGER.info("==================\u5f00\u59cb\u8d44\u6e90\u5f3a\u5236\u68c0\u67e5==================");
        boolean throwError = false;
        StringBuilder msg = new StringBuilder("\u68c0\u67e5\u7ed3\u679c\uff1a");
        for (AbstractResourceMapper<?> mapper : this.abstractResourceMappers) {
            int errorNum = this.checkRes(mapper);
            if (errorNum <= 0) continue;
            throwError = true;
            msg.append("\n * >>>ERROR: ").append(mapper.getResType()).append("\u5f3a\u5236\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u5171\u6709").append(errorNum).append("\u9879\u9519\u8bef");
        }
        if (throwError) {
            Object errorWelcome = "/***\n * _ooOoo_\n * o8888888o\n * 88\" . \"88\n * (| -_- |)\n *  O\\ = /O\n * ___/`---'\\____\n * .   ' \\\\| |// `.\n * / \\\\||| : |||// \\\n * / _||||| -:- |||||- \\\n * | | \\\\\\ - /// | |\n * | \\_| ''\\---/'' | |\n * \\ .-\\__ `-` ___/-. /\n * ___`. .' /--.--\\ `. . __\n * .\"\" '< `.___\\_<|>_/___.' >'\"\".\n * | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n * \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n * `=---='\n * .............................................\n * \u4f5b\u66f0\uff1abug\u6cdb\u6ee5\uff0c\u6211\u5df2\u762b\u75ea\uff01\n";
            msg.append("\n * >>> \u81f3\u7406\u540d\u8a00\uff1a").append(sentence[CommonTools.getRandomNumber((Integer)0, (Integer)(sentence.length - 1))]);
            errorWelcome = (String)errorWelcome + "\n * " + String.valueOf(msg) + "\n";
            LOGGER.error((String)errorWelcome);
            for (int i = 0; i < ERROR_ARRAY.size(); ++i) {
                StringBuilder item = new StringBuilder();
                LOGGER.error(item.append(" * ").append(i + 1).append(". ").append(ERROR_ARRAY.get(i)).toString());
            }
            LOGGER.error("==================\u8d44\u6e90\u5f3a\u5236\u68c0\u67e5\u5b8c\u6210==================\n");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            throw new ServiceException("\u8d44\u6e90\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u7a0b\u5e8f\u5df2\u5f3a\u5236\u4e2d\u6b62");
        }
        String successWelcome = "/***\n *                    _ooOoo_\n *                   o8888888o\n *                   88\" . \"88\n *                   (| -_- |)\n *                    O\\ = /O\n *                ____/`---'\\____\n *              .   ' \\\\| |// `.\n *               / \\\\||| : |||// \\\n *             / _||||| -:- |||||- \\\n *               | | \\\\\\ - /// | |\n *             | \\_| ''\\---/'' | |\n *              \\ .-\\__ `-` ___/-. /\n *           ___`. .' /--.--\\ `. . __\n *        .\"\" '< `.___\\_<|>_/___.' >'\"\".\n *       | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n *         \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n *                    `=---='\n *\n * .............................................\n *          \u4f5b\u7956\u4fdd\u4f51             \u6c38\u65e0BUG\n */";
        LOGGER.info(successWelcome);
        LOGGER.info("\u9001\u7ed9\u4f60\u7684\uff1a{}", (Object)prompt[CommonTools.getRandomNumber((Integer)0, (Integer)(prompt.length - 1))]);
    }

    private int checkRes(AbstractResourceMapper<? extends AbstractResourceMapper.CommonResource> mapper) {
        Map resMap = mapper.getAllMap();
        AtomicInteger i = new AtomicInteger(1);
        AtomicInteger success = new AtomicInteger(0);
        AtomicInteger error = new AtomicInteger(0);
        int size = resMap.size();
        LOGGER.info("\u68c0\u67e5{}\u8d44\u6e90\uff0c\u5171 {} \u4e2a...", (Object)mapper.getResType(), (Object)size);
        resMap.forEach((key, value) -> {
            AbstractResourceMapper.CommonResource resource = mapper.getResource(key, Boolean.valueOf(true), Boolean.valueOf(false));
            assert (resource != null);
            String alias = resource.getAlias();
            String path = resource.getPath();
            try {
                if (mapper.isSupportCompile()) {
                    String source = resource.getSource();
                    Program pros = new Program(source);
                    try {
                        pros.parse();
                        success.addAndGet(1);
                    }
                    catch (RuntimeException e) {
                        String message = e.getMessage();
                        ERROR_ARRAY.add(String.valueOf(mapper.getResType()) + "\u8d44\u6e90[" + alias + "](" + path + ")\u7f16\u8bd1\u9519\u8bef\uff0c" + message);
                        error.addAndGet(1);
                    }
                } else {
                    success.addAndGet(1);
                }
            }
            catch (RuntimeException e) {
                ERROR_ARRAY.add(String.valueOf(mapper.getResType()) + "\u8d44\u6e90\u6587\u4ef6[" + alias + "]\u6307\u5411\u4e86\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684\u4f4d\u7f6e\uff1a" + path);
                error.addAndGet(1);
            }
            i.addAndGet(1);
        });
        String resultMsg = String.valueOf(mapper.getResType()) + "\u8d44\u6e90\u68c0\u67e5\u5b8c\u6210\uff0c\u5171 " + size + " \u4e2a,\u6b63\u786e " + success.get() + " \u4e2a,\u9519\u8bef " + error.get() + " \u4e2a";
        if (error.get() > 0) {
            LOGGER.error(resultMsg);
        } else {
            LOGGER.info(resultMsg);
        }
        return error.get();
    }
}

