/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.web.domain.AjaxResult;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.security.SubstitutionCipherUtil;
import com.af.v4.system.common.security.utils.SecurityUtils;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sensitive"})
public class SensitiveDataController {
    @Autowired
    private LogicService logicService;

    @PostMapping(value={"/decrypt"})
    @Log(title="\u654f\u611f\u6570\u636e\u89e3\u5bc6", businessType=BusinessType.OTHER)
    public AjaxResult decrypt(@RequestBody Map<String, String> request) {
        try {
            if (!SecurityUtils.isAdmin((Long)SecurityUtils.getUserId())) {
                return AjaxResult.error((int)HttpStatus.FORBIDDEN.value(), (String)"\u65e0\u6743\u9650\u6267\u884c\u89e3\u5bc6\u64cd\u4f5c");
            }
            String cipherText = request.get("cipherText");
            if (cipherText == null || cipherText.isEmpty()) {
                return AjaxResult.error((String)"\u5bc6\u6587\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String plainText = SubstitutionCipherUtil.decrypt((String)cipherText);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("plainText", plainText);
            this.logOperation(cipherText, "t_user_sensitive_crypto", "\u89e3\u5bc6\u5b57\u6bb5");
            return AjaxResult.success(result);
        }
        catch (Exception e) {
            String cipherText = request != null ? request.get("cipherText") : null;
            this.logOperation(cipherText, "t_user_sensitive_crypto", "\u89e3\u5bc6\u5b57\u6bb5");
            return AjaxResult.error((String)("\u89e3\u5bc6\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/query"})
    @Log(title="\u654f\u611f\u6570\u636e\u67e5\u8be2", businessType=BusinessType.OTHER)
    public AjaxResult query(@RequestBody Map<String, Object> data) {
        Map<String, Object> params = null;
        try {
            if (data == null || data.isEmpty()) {
                return AjaxResult.error((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            params = data;
            String cipherData = params.get("cipherText") != null ? params.get("cipherText").toString() : null;
            String operateTable = params.get("tableName") != null ? params.get("tableName").toString() : "";
            String operateField = params.get("field") != null ? params.get("field").toString() : "\u654f\u611f\u5b57\u6bb5";
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put(operateField, cipherData);
            this.decryptSensitiveFields(dataMap);
            this.logOperation(cipherData, operateTable, operateField);
            return AjaxResult.success(dataMap);
        }
        catch (Exception e) {
            String cipherData = params != null && params.get("cipherText") != null ? params.get("cipherText").toString() : null;
            this.logOperation(cipherData, "t_user_sensitive_crypto", String.valueOf(params.get("field")));
            return AjaxResult.error((String)("\u67e5\u8be2\u5931\u8d25: " + e.getMessage()));
        }
    }

    private void decryptSensitiveFields(Map<String, String> dataMap) {
        if (dataMap == null) {
            return;
        }
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            try {
                String decryptedValue = SubstitutionCipherUtil.decrypt((String)entry.getValue());
                dataMap.put("decrypted", decryptedValue);
            }
            catch (Exception e) {
                System.err.println("\u89e3\u5bc6\u5b57\u6bb5" + entry.getKey() + "\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private Map<String, Object> callRemoteSensitiveDataQuery(Map<String, Object> params) {
        HashMap<String, Object> callParams = new HashMap<String, Object>(params);
        callParams.put("operatorId", String.valueOf(SecurityUtils.getUserId()));
        callParams.put("operatorName", SecurityUtils.getUsername());
        return (Map)this.logicService.remoteRun("af-system", "sensitiveDataQuery", (JSONObject)callParams);
    }

    private void logOperation(String cipherData, String operateTable, String operateFields) {
        try {
            HashMap<String, String> logParams = new HashMap<String, String>();
            logParams.put("f_operator_id", String.valueOf(SecurityUtils.getUserId()));
            logParams.put("f_operator_name", SecurityUtils.getUsername());
            logParams.put("f_cipher_data", cipherData);
            logParams.put("f_operate_table", operateTable);
            logParams.put("f_operate_fields", operateFields);
            LocalDateTime now = LocalDateTime.now();
            logParams.put("f_operator_time", now.toString());
            logParams.put("f_module_name", "af-system");
            JSONObject logParamsJson = new JSONObject(logParams);
            this.logicService.remoteRun("af-system", "recordAuditLog", logParamsJson);
        }
        catch (Exception e) {
            System.err.println("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25: " + e.getMessage());
        }
    }
}

