package com.af.v4.v3.workflow.perform;

import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.v3.apply.plugin.ApplyUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

import java.io.InputStream;
import java.util.*;
import java.util.regex.Pattern;

/**
 * 临时产生人员映射关系
 */
public class PersonService {

    public static void Run(String organization, String personExpression, Session session, String username, String userid) {

        if ("".equals(personExpression)) {
            return;
        }

        // 获得实际人员表达式，personExpression有可能是给ldap表达式，与实际不同
        String realPerson = getActorid(personExpression);

        sessionDel(session, realPerson, organization);

        Map<String, Object> actor;
        // 表达式对应人员
        Set<Map<String, Object>> persons = new HashSet<>();
        String name = "";

        // 查询当前表达式及对应人员
        actor = (Map<String, Object>) session.get("t_actor", realPerson);

        // 如果存在直接删除
        if (actor != null) {
            session.evict(actor);
            // 确保此次查询一直是从库中进行查询
            actor = (Map<String, Object>) session.get("t_actor", realPerson);
            persons = (Set<Map<String, Object>>) actor.get("f_person");
        } else {
            actor = new HashMap<>();
            actor.put("id", realPerson);
        }

        String str;
        // 人员 传入id
        if (personExpression.startsWith("PI")) {
            // 人员id
            name = personExpression.substring(3,
                    personExpression.length() - 1);
            str = "{source: 'this', userid: '" + name + "'}";
            getPerson(persons, str, organization);
//			sessionDel(session, personExpression, organization);
        }
        // 如果是人员 传入用户名
        else if (personExpression.startsWith("P")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            Map<String, Object> map = new HashMap<>();
            map.put("userid", name);
            map.put("userseq", name);
            map.put("org", organization);
            persons.add(map);
//			sessionDel(session, personExpression, organization);
        }
        // 是部门
        else if (personExpression.startsWith("D")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            str = "{source: 'this.getParentByName($" + organization + "$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            getPerson(persons, str, organization);
//			sessionDel(session, personExpression, organization);
        }
        // 是ID数组，暂定部门
        else if (personExpression.startsWith("I")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            String[] ids = name.split(",");
            getPersonList(persons, ids);
//			sessionDel(session, personExpression, organization);
        }
        // 是角色数组
        else if (personExpression.startsWith("RS")) {
            name = personExpression.substring(3,
                    personExpression.length() - 1);
            String[] roles = name.split(",");
            for (String role : roles) {
                str = "{source: 'this.getParentByName($" + organization + "$).getChildByName($" + role + "$).getChildren()', userid: '" + userid + "'}";
                getPerson(persons, str, organization);
            }
//			sessionDel(session, personExpression, organization);
        }
        // 是角色
        else if (personExpression.startsWith("R")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            str = "{source: 'this.getParentByName($" + organization + "$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            getPerson(persons, str, organization);
//			sessionDel(session, personExpression, organization);
        } else {
            //非R非P
            //对表达式字符串进行转义
            personExpression = getExpression(personExpression);
            getPerson(persons, personExpression, organization);
            //删除数据库中已存在的数据
//			sessionDel(session, realPerson, organization);
        }
        actor.put("f_person", persons);
        //放入资源类型【id或者是名称】
        actor.put("res", name);
        //保存数据到数据库
        session.saveOrUpdate("t_actor", actor);
    }

    public static void Run(String personExpression, Session session, String username, String userid) {

        if ("".equals(personExpression)) {
            return;
        }

        Map<String, Object> actor;

        // 获得实际人员表达式，personExpression有可能是给ldap表达式，与实际不同
        String realPerson = getActorid(personExpression);

        // 查询当前表达式及对应人员
        actor = (Map<String, Object>) session.get("t_actor", realPerson);

        // 如果存在直接删除
        if (actor != null) {
            session.remove(actor);
        } else {
            actor = new HashMap<>();
            actor.put("id", realPerson);
        }

        // 表达式对应人员
        Set<Map<String, Object>> persons = new HashSet<>();
        String name = "";
        String str;
        // 人员 传入id
        if (personExpression.startsWith("PI")) {
            // 人员id
            name = personExpression.substring(3,
                    personExpression.length() - 1);
            str = "{source: 'this', userid: '" + name + "'}";
            getPerson(persons, str);
//			sessionDel(session, personExpression);
        }
        // 如果是人员 传入用户名
        else if (personExpression.startsWith("P")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            Map<String, Object> map = new HashMap<>();
            map.put("userid", name);
            map.put("userseq", name);
            persons.add(map);
        }
        // 是部门
        else if (personExpression.startsWith("D")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            str = "{source: 'this.getParentByType($organization$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            getPerson(persons, str);
//			sessionDel(session, personExpression);
        }
        // 是ID数组，暂定部门
        else if (personExpression.startsWith("I")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            String[] ids = name.split(",");
            getPersonList(persons, ids);
//			sessionDel(session, personExpression);
        }
        // 是角色数组
        else if (personExpression.startsWith("RS")) {
            name = personExpression.substring(3,
                    personExpression.length() - 1);
            String[] roles = name.split(",");
            for (String role : roles) {
                str = "{source: 'this.getParentByType($organization$).getChildByName($" + role + "$).getChildren()', userid: '" + userid + "'}";
                getPerson(persons, str);
            }
//			sessionDel(session, personExpression);
        }
        // 是角色
        else if (personExpression.startsWith("R")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            str = "{source: 'this.getParentByType($organization$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            getPerson(persons, str);
//			sessionDel(session, personExpression);
        } else {
            //非R非P
            //对表达式字符串进行转义
            personExpression = getExpression(personExpression);
            getPerson(persons, personExpression);
            //删除数据库中已存在的数据
//			sessionDel(session,realPerson);
        }
        actor.put("f_person", persons);
        //放入资源类型【id或者是名称】
        actor.put("res", name);
        //保存数据到数据库
        // 防止并行节点人员表达式一样，导致同一session中存在多个id相同数据
        if (session.get("t_actor", actor.get("id").toString()) != null) {
            session.evict(session.get("t_actor", actor.get("id").toString()));
        }
        session.saveOrUpdate("t_actor", actor);
    }

    public static void Run(String personExpression, Session session) {

        if ("".equals(personExpression)) {
            return;
        }

        // 获得实际人员表达式，personExpression有可能是给ldap表达式，与实际不同
        String realPerson = getActorid(personExpression);
        Map<String, Object> actor = new HashMap<>();
        actor.put("id", realPerson);

        Set<Map<String, Object>> persons = new HashSet<>();
        String name = "";
        String str;
        // 如果是人员
        if (personExpression.startsWith("P")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            Map<String, Object> map = new HashMap<>();
            map.put("userid", name);
            map.put("userseq", name);
            persons.add(map);
        }
        // 是部门
        else if (personExpression.startsWith("D")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            str = "{source: 'tool.getChildrenOfResName($" + name
                    + "$)', userid: ''}";
            getPerson(persons, str);
            sessionDel(session, personExpression);
        }
        // 是ID数组，暂定部门
        else if (personExpression.startsWith("I")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            String[] ids = name.split(",");
            getPersonList(persons, ids);
            sessionDel(session, personExpression);
        }
        // 是角色
        else if (personExpression.startsWith("R")) {
            name = personExpression.substring(2,
                    personExpression.length() - 1);
            str = "{source: 'tool.getChildrenOfResName($" + name
                    + "$)', userid: ''}";
            getPerson(persons, str);
            sessionDel(session, personExpression);
        } else {//非R非P
            //对表达式字符串进行转义
            personExpression = getExpression(personExpression);
            getPerson(persons, personExpression);
            //删除数据库中已存在的数据
            sessionDel(session, realPerson);
        }
        actor.put("f_person", persons);
        //放入资源类型【id或者是名称】
        actor.put("res", name);
        //保存数据到数据库
        session.saveOrUpdate("t_actor", actor);
    }

    //是否是数字【用来判断id】
    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-+]?\\d*$");
        return pattern.matcher(str).matches();
    }

    //session执行插入前删除
    public static void sessionDel(Session session, String str) {
        str = str.replaceAll("'", "''");
        String hql = "DELETE t_actorperson WHERE  actorid='" + str + "'";
        Query query = session.createNativeQuery(hql);
        query.executeUpdate();
    }

    //session执行插入前删除
    public static void sessionDel(Session session, String str, String organization) {
        str = str.replaceAll("'", "''");
        String hql = "DELETE t_actorperson WHERE actorid = '" + str + "' and org = '" + organization + "'";
        Query query = session.createNativeQuery(hql);
        query.executeUpdate();
    }

    //获取人员出入的是id组
    public static Set<Map<String, Object>> getPersonList(Set<Map<String, Object>> persons, String[] str) {
        for (String s : str) {
            //开始循环拿取资源子
            String resstr = "{source: 'tool.getChildrenOfResId($" + s
                    + "$)', userid: ''}";

            String url = ApplyUtils.getUrl();
            String actual = RestTools.post( url + "/rs/search", resstr, new JSONObject().toString());

            if (!actual.contains("status: ")) {
                Object json = new JSONTokener(actual).nextValue();
                if (json instanceof JSONObject obj) {
                    Map<String, Object> map = new HashMap<>();
                    //获取人选的id以及name
                    map.put("userseq", obj.getString("id"));
                    map.put("userid", obj.getString("name"));
                    persons.add(map);
                } else if (json instanceof JSONArray) {
                    JSONArray arr = new JSONArray(actual);
                    for (int i = 0; i < arr.length(); i++) {
                        JSONObject obj = arr.getJSONObject(i);
                        Map<String, Object> map = new HashMap<>();
                        //获取人选的id以及name
                        map.put("userseq", obj.getString("id"));
                        map.put("userid", obj.getString("name"));
                        persons.add(map);
                    }
                }
            }
        }
        return persons;
    }

    //获取人员
    public static Set<Map<String, Object>> getPerson(Set<Map<String, Object>> persons, String str) {
        String url = ApplyUtils.getUrl();
        String actual = RestTools.post( url + "/rs/search", str, new JSONObject().toString());
        if (!actual.contains("status: ")) {
            Object json = new JSONTokener(actual).nextValue();
            if (json instanceof JSONObject obj) {
                Map<String, Object> map = new HashMap<>();
                //获取人选的id以及name
                map.put("userseq", obj.getString("id"));
                map.put("userid", obj.getString("name"));
                persons.add(map);
            } else if (json instanceof JSONArray) {
                JSONArray arr = new JSONArray(actual);
                for (int i = 0; i < arr.length(); i++) {
                    JSONObject obj = arr.getJSONObject(i);
                    Map<String, Object> map = new HashMap<>();
                    //获取人选的id以及name
                    map.put("userseq", obj.getString("id"));
                    map.put("userid", obj.getString("name"));
                    persons.add(map);
                }
            }
        }
        return persons;
    }

    /**
     * 获取人员
     */
    public static Set<Map<String, Object>> getPerson(Set<Map<String, Object>> persons, String str, String organization) {
        String url = ApplyUtils.getUrl();
        String actual = RestTools.post( url + "/rs/search", str, new JSONObject().toString());

        if (!actual.contains("status: ")) {
            Object json = new JSONTokener(actual).nextValue();
            if (json instanceof JSONObject obj) {
                Map<String, Object> map = new HashMap<>();
                //获取人选的id以及name
                map.put("userseq", obj.getString("id"));
                map.put("userid", obj.getString("name"));
                map.put("org", organization);
                persons.add(map);
            } else if (json instanceof JSONArray) {
                JSONArray arr = new JSONArray(actual);
                for (int i = 0; i < arr.length(); i++) {
                    JSONObject obj = arr.getJSONObject(i);
                    Map<String, Object> map = new HashMap<>();
                    //获取人选的id以及name
                    map.put("userseq", obj.getString("id"));
                    map.put("userid", obj.getString("name"));
                    map.put("org", organization);
                    persons.add(map);
                }
            }
        }
        return persons;
    }

    /**
     * 转义表达式
     */
    public static String getExpression(String personExpression) {
        // 转义 {: @lt;   } : @gt;  $ : @amp;
        String str = "";
        if (personExpression != null) {
            str = personExpression.replace("@lt;", "{");
            str = str.replace("@gt;", "}");
            str = str.replace("@amp;", "$");
        }
        //获取userid
        return getUserid(str, 1);

    }

    /**
     * 替换this
     */
    public static String getFixEXpression(String personExpression) {
        // String userid=getUserid(personExpression,0);
        // 替换表达式source中的this为userid
        // 之前替换this出现bug 现在改为不替换 直接存储
        return getUserid(personExpression, 1);
    }

    /**
     * 获取userid
     */
    public static String getUserid(String str, int i) {
        JSONObject json = new JSONObject(str);
        String userid = json.getString("userid");
        int index;
        String olduserid = userid;
        //截取userid中正确的userid，对userid中的“.”进行判断截取最后一个字段
        if (userid.lastIndexOf(".") == userid.length() - 1) {//userid最后
            userid = userid.substring(0, userid.length() - 1);
            index = userid.lastIndexOf(".");
            userid = userid.substring(index + 1);
            //返回表达式i=0，返回userid，i=1，返回表达式
        } else {
            index = userid.lastIndexOf(".");
            if (index != -1) {
                userid = userid.substring(index + 1);
            }
        }
        if (i == 0) {
            return userid;
        } else {
            return str.replace(olduserid, userid);
        }
    }

    /**
     * 获取actorid
     */
    public static String getActorid(String str) {
        if (str.isEmpty() || str.startsWith("I") || str.startsWith("R") || str.startsWith("P") || str.startsWith("D")) {
            return str;
        }
        //对非R非P角色的actorid进行转义
        str = str.replace("@lt;", "{");
        str = str.replace("@gt;", "}");
        str = str.replace("@amp;", "$");
        str = getFixEXpression(str);
        return str;
    }

    public static String getPath() {
        String path = "";
        SAXReader read = new SAXReader();
        try (InputStream input = PersonService.class.getClassLoader()
                .getResourceAsStream("workflow.xml")) {
            Document document = read.read(input);
            Element root = document.getRootElement();
            for (Iterator<Element> it = root.elementIterator("url"); it.hasNext(); ) {
                Element elm = it.next();
                path = elm.attribute("path").getValue();
            }
            return path;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
