package com.af.v4.v3.workflow.perform;

import org.w3c.dom.Element;

import java.io.Serial;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 活动定义
 *
 * @author Browsesoft
 * @version 1.0
 */
public class ActivityDef extends FlowDef {
    @Serial
    private static final long serialVersionUID = 6631734491662904499L;
    /**
     * 活动所属流程
     */
    private final ProcessDef process;
    /**
     * 活动的参与者
     */
    private final ActorDef actor;
    /**
     * 超时设置
     */
    private String timeout = null;
    /**
     * 节点类型
     */
    private String nodetype = null;
    private Date deadLine;
    /**
     * 执行者表达式
     */
    private String personExpression = null;


    /**
     * 使用参与者以及DOM元素构造
     */
    public ActivityDef(ActorDef actor, ProcessDef process, Element e) {
        this.actor = actor;
        this.process = process;
        setElement(e);
    }

    public String getPersonExpression() {
        return personExpression;
    }

    public void setPersonExpression(String personExpression) {
        this.personExpression = personExpression;
    }

    public Date getDeadLine() {
        return deadLine;
    }

    public void setDeadLine(Date deadLine) {
        this.deadLine = deadLine;
    }

    public String getTimeout() {
        return timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getNodetype() {
        return nodetype;
    }

    public void setNodetype(String nodetype) {
        this.nodetype = nodetype;
    }

    /**
     * 设置属性
     */
    public void setElement(Element e) {
        super.setElement(e);
    }

    /**
     * 得到活动所属流程
     *
     * @return 活动所属流程
     */
    public ProcessDef getProcess() {
        return process;
    }

    /**
     * 得到活动所属参与者
     */
    public ActorDef getActor() {
        return actor;
    }

    /**
     * 得到活动的所有前驱转移
     *
     * @return 活动的所有前驱
     */
    public List<DiversionDef> getJoins() {
        List<DiversionDef> result = new ArrayList<>();
        List<DiversionDef> diversions = process.getDiversions();
        for (DiversionDef diversionDef : diversions) {
            // 转移的结束为该活动
            if (diversionDef.getTail() == this) {
                result.add(diversionDef);
            }
        }
        return result;
    }

    /**
     * 得到活动的后继转移
     */
    public List<DiversionDef> getSplits() {
        List<DiversionDef> result = new ArrayList<>();
        List<DiversionDef> diversions = process.getDiversions();
        for (DiversionDef diversionDef : diversions) {
            // 转移的开始为该活动
            if (diversionDef.getHead() == this) {
                result.add(diversionDef);
            }
        }
        return result;
    }
}
