package com.af.v4.v3.apply.plugin;

import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;

import java.util.Base64;

/**
 * @author Sys
 * @date 2023-04-28 15:43
 */
public class SM3Utils {
    private static final String ENCODING = "UTF-8";


    /**
     * SM3加密方式之：不提供密钥的方式 SM3加密，返回加密后长度为64位的16进制字符串
     *
     * @param src 明文
     * @return
     */
    public static String encrypt(String src) throws Exception {
        return ByteUtils.toHexString(getEncryptBySrcByte(src.getBytes(ENCODING)));
    }

    /**
     * 返回长度为32位的加密后的byte数组
     *
     * @param srcByte
     * @return
     */
    public static byte[] getEncryptBySrcByte(byte[] srcByte) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(srcByte, 0, srcByte.length);
        byte[] encryptByte = new byte[sm3.getDigestSize()];
        sm3.doFinal(encryptByte, 0);
        return encryptByte;
    }


    public static String getSign(String appId, String appSecret, String timestamp, String nonce) throws Exception {
        // 此处生成签名  
        String stringToSign = appId + timestamp + nonce + appSecret;
        String md5f = SM3Utils.encrypt(stringToSign);
        String s = md5f.substring(2, 8);
        md5f = s + md5f;
        String md5s = SM3Utils.encrypt(md5f);
        //进行BASE64编码
        return Base64.getEncoder().encodeToString(md5s.getBytes(ENCODING));
    }

}
