package com.af.v4.v3.apply.plugin;

import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Call {

    private static final Logger LOGGER = LoggerFactory.getLogger(Call.class);

    /**
     * 呼叫接口鉴权
     *
     * @param time 时间戳
     * @param sign 加密结果
     * @return true/false
     */
    public static boolean verify(String time, String sign) {
        String path = "config/callConfig.json";

        JSONObject config = JsonTools.readJsonFile(path);

        String appkey = config.getString("appkey");
        String secretKey = config.getString("secretKey");

        // 明文串 appkey+secretKey+time
        String rule = appkey + secretKey + time;

        // 密文
        String cipher = CommonTools.md5(rule);

        return cipher.equals(sign);
    }
}
