/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.utils;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.enums.DbType;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DataTypeUtils {
    private static final Map<DbType, Map<Pattern, String>> TYPE_MAPPINGS = new HashMap<DbType, Map<Pattern, String>>();

    private static void initializeTypeMappings() {
        HashMap<Pattern, String> oracleMapping = new HashMap<Pattern, String>();
        oracleMapping.put(Pattern.compile("datetime"), "timestamp");
        oracleMapping.put(Pattern.compile("getdate\\(\\)"), "sysdate");
        oracleMapping.put(Pattern.compile("varchar\\("), "varchar2(");
        oracleMapping.put(Pattern.compile("numeric\\("), "NUMBER(");
        oracleMapping.put(Pattern.compile("\\bint\\b"), "number(10)");
        oracleMapping.put(Pattern.compile("bigint"), "number(19)");
        oracleMapping.put(Pattern.compile("\\bbit\\b"), "number(1)");
        oracleMapping.put(Pattern.compile("text"), "clob");
        TYPE_MAPPINGS.put(DbType.oracle, oracleMapping);
        HashMap<Pattern, String> postgresMapping = new HashMap<Pattern, String>();
        postgresMapping.put(Pattern.compile("datetime"), "timestamp");
        postgresMapping.put(Pattern.compile("getdate\\(\\)"), "current_timestamp");
        postgresMapping.put(Pattern.compile("\\bbit\\b"), "boolean");
        postgresMapping.put(Pattern.compile("uniqueidentifier"), "uuid");
        postgresMapping.put(Pattern.compile("nvarchar"), "varchar");
        postgresMapping.put(Pattern.compile("ntext"), "text");
        TYPE_MAPPINGS.put(DbType.postgresql, postgresMapping);
        TYPE_MAPPINGS.put(DbType.opengauss, postgresMapping);
        HashMap<Pattern, String> mysqlMapping = new HashMap<Pattern, String>();
        mysqlMapping.put(Pattern.compile("getdate\\(\\)"), "current_timestamp");
        mysqlMapping.put(Pattern.compile("nvarchar"), "varchar");
        mysqlMapping.put(Pattern.compile("uniqueidentifier"), "char(36)");
        mysqlMapping.put(Pattern.compile("ntext"), "longtext");
        TYPE_MAPPINGS.put(DbType.mysql, mysqlMapping);
        TYPE_MAPPINGS.put(DbType.doris, mysqlMapping);
        HashMap<Pattern, String> sqlServerMapping = new HashMap<Pattern, String>();
        sqlServerMapping.put(Pattern.compile("timestamp"), "datetime");
        sqlServerMapping.put(Pattern.compile("sysdate"), "getdate()");
        sqlServerMapping.put(Pattern.compile("current_timestamp"), "getdate()");
        sqlServerMapping.put(Pattern.compile("varchar2"), "nvarchar");
        sqlServerMapping.put(Pattern.compile("clob"), "ntext");
        sqlServerMapping.put(Pattern.compile("boolean"), "bit");
        TYPE_MAPPINGS.put(DbType.sqlserver, sqlServerMapping);
        HashMap dmMapping = new HashMap(oracleMapping);
        TYPE_MAPPINGS.put(DbType.dm, dmMapping);
        HashMap<Pattern, String> clickhouseMapping = new HashMap<Pattern, String>();
        clickhouseMapping.put(Pattern.compile("datetime"), "DateTime");
        clickhouseMapping.put(Pattern.compile("getdate\\(\\)"), "now()");
        clickhouseMapping.put(Pattern.compile("\\bbit\\b"), "UInt8");
        clickhouseMapping.put(Pattern.compile("\\bint\\b"), "Int32");
        clickhouseMapping.put(Pattern.compile("bigint"), "Int64");
        clickhouseMapping.put(Pattern.compile("nvarchar|varchar"), "String");
        clickhouseMapping.put(Pattern.compile("ntext|text|clob"), "String");
        TYPE_MAPPINGS.put(DbType.clickhouse, clickhouseMapping);
    }

    public static String convertDataType(String originalType, DbType dbType) {
        if (originalType == null || originalType.isEmpty()) {
            return originalType;
        }
        Map<Pattern, String> mappings = TYPE_MAPPINGS.get(dbType);
        if (mappings == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b: " + String.valueOf(dbType));
        }
        String result = originalType;
        for (Map.Entry<Pattern, String> entry : mappings.entrySet()) {
            result = entry.getKey().matcher(result).replaceAll(entry.getValue());
        }
        return result;
    }

    public static String getTableNameWithCase(String tableName, Dialect dialect) {
        if (dialect.isOracleFamily()) {
            return tableName.toUpperCase();
        }
        if (dialect.isPostgresFamily()) {
            return tableName.toLowerCase();
        }
        return tableName;
    }

    public static String getFieldNameWithCase(String fieldName, Dialect dialect) {
        if (dialect.isOracleFamily()) {
            return fieldName.toUpperCase();
        }
        if (dialect.isPostgresFamily()) {
            return fieldName.toLowerCase();
        }
        return fieldName;
    }

    static {
        DataTypeUtils.initializeTypeMappings();
    }
}

