package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 旧版v3获取配置信息控制器（兼容）
 *
 * @author ZhangZhenyu
 * @apiNote 该api实现的后续使用liuli接口代替，仅用于保持对v3及以前版本的兼容，
 */
@Deprecated(since = "1.0.0")
@RestController
@RequestMapping("/vue")
public class VueController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VueController.class);
    private final LiuLiConfigService liuLiConfigService;

    public VueController(LiuLiConfigService liuLiConfigService) {
        this.liuLiConfigService = liuLiConfigService;
    }

    @GetMapping({"", "/"})
    public ResponseEntity<String> getByModule() {
        return getResponse(null, "旧Vue配置迁移");
    }

    @GetMapping("/{configName}")
    public ResponseEntity<String> getConfig(@PathVariable String configName) {
        // 如果config 带有 .json 后缀 去掉
        if (configName.endsWith(".json")) {
            configName = configName.substring(0, configName.indexOf(".json"));
        }
        return getResponse(configName, null);
    }

    private ResponseEntity<String> getResponse(String configName, String moduleName) {
        try {
            JSONObject config = configName == null ? liuLiConfigService.getByModule(moduleName) : liuLiConfigService.get(configName);
            return ResponseEntity.status(HttpStatus.OK).body(config == null ? null : config.toString());
        } catch (Exception e) {
            LOGGER.error("获取配置失败", e);
            return ResponseEntity.status(704).body("获取配置信息失败");
        }
    }
}
