/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.redis.exception.LockTimeoutException;
import com.af.v4.system.common.resource.constant.CacheKey;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.runtime.annotation.OpenApi;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logic"})
public class LogicController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicController.class);
    private static final String RESPONSE_HEADER = "header";
    private static final String RESPONSE_CONTENT = "content";
    private static final String RESPONSE_VALUE = "value";
    private final LogicService logicService;
    private final LogicMapper logicMapper;
    private final RedisService redisService;

    public LogicController(LogicService logicService, LogicMapper logicMapper, RedisService redisService) {
        this.logicService = logicService;
        this.logicMapper = logicMapper;
        this.redisService = redisService;
    }

    @Log(title="\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"{logicName}"}, produces={"application/json"})
    public Object run(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletResponse response, HttpServletRequest request) {
        String params = this.getRequestParams(values, request);
        return this.runMain(logicName, params, request, response);
    }

    @Log(title="\u5f02\u6b65\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"/async/{logicName}"}, produces={"application/json"})
    public Object runAsync(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletRequest request) {
        String params = this.getRequestParams(values, request);
        this.logicService.runAsync(logicName, params).whenComplete((o, e) -> {
            if (o != null) {
                LOGGER.info("\u5f02\u6b65\u8c03\u7528\u7ed3\u679c\uff1a{}", o);
            }
        });
        return R.ok((Object)"ok");
    }

    @Log(title="\u65e0token\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"/openapi/{logicName}"}, produces={"application/json"})
    @OpenApi
    public Object runByNoToken(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletResponse response, HttpServletRequest request) {
        return this.run(logicName, values, response, request);
    }

    @Log(title="\u65e0token\u5f02\u6b65\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"/openapi/async/{logicName}"}, produces={"application/json"})
    @OpenApi
    public Object runAsyncByNoToken(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletRequest request) {
        return this.runAsync(logicName, values, request);
    }

    private String getRequestParams(String values, HttpServletRequest request) {
        JSONObject paramsJson;
        if (StringUtils.isEmpty((String)values)) {
            paramsJson = new JSONObject();
        } else if (values.startsWith("{") && values.endsWith("}")) {
            paramsJson = new JSONObject(values);
        } else {
            paramsJson = new JSONObject();
            paramsJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = (String)headerNames.nextElement();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramsJson.put(RESPONSE_HEADER, (Object)header);
            }
        }
        Map parameterMap = request.getParameterMap();
        parameterMap.forEach((key, value) -> {
            if (((String[])value).length > 0 && !paramsJson.has(key)) {
                paramsJson.put(key, (Object)value[0]);
            }
        });
        return paramsJson.toString();
    }

    private Object runMain(String logicName, String values, HttpServletRequest request, HttpServletResponse response) {
        LogicMapper.LogicResource resource;
        boolean isEnableCache;
        String requestId = request.getHeader("X-Request-ID");
        if (requestId != null) {
            LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u8bf7\u6c42\u552f\u4e00\u6807\u8bc6\uff1a{}"})), (Object)requestId);
        }
        if (!(isEnableCache = (resource = (LogicMapper.LogicResource)this.logicMapper.getResource(logicName)).isCache())) {
            Object runResult = this.logicService.run(logicName, values);
            return this.buildResponse(logicName, runResult, response);
        }
        String cacheKeyValue = resource.getCacheKey();
        if (!values.startsWith("{")) {
            LOGGER.warn((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Logic[{}}]\u7684\u8bf7\u6c42\u53c2\u6570\u4e0d\u6ee1\u8db3\u83b7\u53d6\u81ea\u5b9a\u4e49\u7f13\u5b58Key\uff0c\u5df2\u8df3\u8fc7\u83b7\u53d6\u7f13\u5b58"})), (Object)logicName);
            Object runResult = this.logicService.run(logicName, values);
            return this.buildResponse(logicName, runResult, response);
        }
        JSONObject params = new JSONObject(values);
        String paramsStr = Optional.ofNullable(cacheKeyValue).isPresent() && params.has(cacheKeyValue) ? params.get(cacheKeyValue).toString() : ConvertTools.base64Encode((byte[])new TreeMap(params.toMap()).toString().getBytes(StandardCharsets.UTF_8));
        String cacheKey = CacheKey.getLogicDataCacheKey((String)logicName, (String)paramsStr);
        Object cacheResult = this.redisService.get(cacheKey);
        if (cacheResult != null) {
            LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Logic[{}]\u547d\u4e2d\u7f13\u5b58\uff0c\u53c2\u6570\uff1a{}"})), (Object)logicName, (Object)values);
            return this.buildResponse(logicName, cacheResult, response);
        }
        try {
            long cacheTime = resource.getTime();
            Object result = this.redisService.lock(cacheKey, Integer.valueOf(cacheTime <= 0L ? 0 : 60), Integer.valueOf(300), () -> {
                if (cacheTime <= 0L) {
                    return this.logicService.run(logicName, values);
                }
                Object newCacheResult = this.redisService.get(cacheKey);
                if (newCacheResult != null) {
                    LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Logic[{}]\u547d\u4e2d\u7f13\u5b58\uff0c\u53c2\u6570\uff1a{}"})), (Object)logicName, (Object)values);
                    return newCacheResult;
                }
                newCacheResult = this.logicService.run(logicName, values);
                if (newCacheResult != null) {
                    this.redisService.set(cacheKey, newCacheResult, (Object)cacheTime);
                    LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Logic[{}]\u7f13\u5b58\u6210\u529f\uff0c\u5b58\u6d3b\u65f6\u95f4\uff1a{}\u79d2"})), (Object)logicName, (Object)cacheTime);
                }
                return newCacheResult;
            });
            return this.buildResponse(logicName, result, response);
        }
        catch (LockTimeoutException e) {
            String demoteLogicName = resource.getDemoteLogicName();
            if (demoteLogicName != null) {
                return this.buildResponse(logicName, this.logicService.run(demoteLogicName, values), response);
            }
            throw new ServiceException("\u91cd\u590d\u8bf7\u6c42", Integer.valueOf(409));
        }
    }

    private Object buildResponse(String logicName, Object runResult, HttpServletResponse response) {
        Map map;
        HashMap<String, Object> result;
        JSONObject object;
        if (runResult instanceof JSONObject && (object = (JSONObject)runResult).has(RESPONSE_HEADER) && object.has(RESPONSE_CONTENT)) {
            JSONObject paramHeader = object.getJSONObject(RESPONSE_HEADER);
            for (String key : paramHeader.keySet()) {
                response.setHeader(key, String.valueOf(paramHeader.get(key)));
            }
            runResult = object.get(RESPONSE_CONTENT);
        }
        LogicMapper.LogicResource resource = (LogicMapper.LogicResource)this.logicMapper.getResource(logicName);
        if (runResult instanceof JSONObject) {
            JSONObject json = (JSONObject)runResult;
            result = json.toMap();
        } else if (runResult instanceof JSONArray) {
            JSONArray array = (JSONArray)runResult;
            result = array.toList();
        } else if (runResult instanceof Map || runResult instanceof Collection) {
            result = runResult;
        } else if (runResult == null) {
            result = null;
        } else if (!resource.isCallbackApi()) {
            HashMap<String, Object> map2 = new HashMap<String, Object>(1);
            map2.put(RESPONSE_VALUE, runResult);
            result = map2;
        } else {
            result = runResult;
        }
        if (resource.isCallbackApi()) {
            return result;
        }
        if (result instanceof Map && (map = (Map)result).containsKey("status")) {
            String status = map.get("status").toString();
            if (status.equals("200") && map.containsKey("data")) {
                return R.ok(map.get("data"));
            }
            if (!status.equals("200") && map.containsKey("msg")) {
                return R.fail((Object)status, (String)((String)map.get("msg")));
            }
        }
        return R.ok((Object)result);
    }
}

