package com.af.v4.system.common.websocket.service;

import com.github.linyuzai.connection.loadbalance.core.extension.PathMessage;
import com.github.linyuzai.connection.loadbalance.core.extension.UserMessage;
import com.github.linyuzai.connection.loadbalance.websocket.concept.WebSocketLoadBalanceConcept;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class WebsocketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketService.class);

    private final WebSocketLoadBalanceConcept concept;

    public WebsocketService(WebSocketLoadBalanceConcept concept) {
        this.concept = concept;
    }

    /**
     * 发送消息给用户
     *
     * @param msg         消息内容
     * @param userIdArray 用户ID集合
     */
    public void sendToUsers(String msg, JSONArray userIdArray) {
        List<String> userIds = new ArrayList<>(userIdArray.length());
        userIdArray.forEach(i -> userIds.add(i.toString()));
        concept.send(new UserMessage(msg, userIds));
    }

    /**
     * 发送消息给服务订阅者
     *
     * @param msg          消息内容
     * @param serviceArray 服务集合
     */
    public void sendToServices(String msg, JSONArray serviceArray) {
        List<String> serviceNames = new ArrayList<>(serviceArray.length());
        serviceArray.forEach(i -> serviceNames.add(i.toString()));
        concept.send(new PathMessage(msg, serviceNames));
    }
}
