package com.af.v4.system.common.socket.core.server.modbus.util;

import com.af.v4.system.common.socket.core.server.modbus.message.MBAPHeader;
import io.netty.buffer.ByteBuf;

public class MBAPHeaderDecoder {

    public static MBAPHeader decode(ByteBuf byteBuf) {
        MBAPHeader mbapHeader = new MBAPHeader();
        short transactionId = byteBuf.readShort();
        mbapHeader.setTransactionId(transactionId);
        short protocolId = byteBuf.readShort();
        mbapHeader.setProtocolId(protocolId);
        short length = (short) byteBuf.readUnsignedShort();
        mbapHeader.setLength(length);
        byte unitId = (byte) byteBuf.readUnsignedByte();
        mbapHeader.setUnitId(unitId);
        return mbapHeader;
    }
}
