package com.af.v4.system.common.socket.core.server.modbus.message;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.core.server.modbus.util.FunctionCodeConstants;
import io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ModbusSendUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusSendUtil.class);

    public static void readData(String ip, ClientEvent event) {
        Channel channel = ClientManager.getChannelData().channel();
        if (channel != null) {
            MBAPHeader mbapHeader = createMbapHeader(event);
            PduPayload pduPayload = createPduPayload(event);
            TCPModbusMessage tcpModbusMessage = new TCPModbusMessage();
            tcpModbusMessage.mbapHeader = mbapHeader;
            tcpModbusMessage.pduPayload = pduPayload;
            channel.writeAndFlush(tcpModbusMessage);
        }
    }

    private static MBAPHeader createMbapHeader(ClientEvent event) {
        return TCPModbusMessageFactory.newReadReqHeader(event);
    }

    private static PduPayload createPduPayload(ClientEvent event) {
        int functionCode = event.getFunctionCode();
        return switch (functionCode) {
            case FunctionCodeConstants.ReadCoils -> TCPModbusMessageFactory.newReadCoilsReqPdu(event);
            case FunctionCodeConstants.ReadHoldingRegisters -> TCPModbusMessageFactory.newReadHoldingRegistersReqPdu(event);
            default -> throw new RuntimeException(STR."not support function code...\{functionCode}");
        };
    }


    //TODO 写单个线圈
    public String writeSingleCoil(String ip) {
        ChannelData channelData = ClientManager.getChannelData();
        Channel channel = channelData.channel();
        if (channel != null) {
            MBAPHeader mbapHeader = TCPModbusMessageFactory.newWriteSingleCoilReqHeader();
            PduPayload pduPayload = TCPModbusMessageFactory.newWriteSingleCoilReqPdu();

            TCPModbusMessage tcpModbusMessage = new TCPModbusMessage();
            tcpModbusMessage.mbapHeader = mbapHeader;
            tcpModbusMessage.pduPayload = pduPayload;
            channel.writeAndFlush(tcpModbusMessage);
            return "sucess";
        } else {
            return "fail";
        }
    }

    //TODO 写单个寄存器
    public String writeSingleRegister(String ip) {
        ChannelData channelData = ClientManager.getChannelData();
        Channel channel = channelData.channel();
        if (channel != null) {
            MBAPHeader mbapHeader = TCPModbusMessageFactory.newWriteSingleRegisterReqHeader();
            PduPayload pduPayload = TCPModbusMessageFactory.newWriteSingleRegisterReqPdu();

            TCPModbusMessage tcpModbusMessage = new TCPModbusMessage();
            tcpModbusMessage.mbapHeader = mbapHeader;
            tcpModbusMessage.pduPayload = pduPayload;
            channel.writeAndFlush(tcpModbusMessage);
            return "sucess";
        } else {
            return "fail";
        }
    }

    // 根据地址 和 读取寄存器长度 生成modbus 唯一事务标识符
    public static short getTransactionIdentifier(String address, int length) {
        // 将地址转换为整数
        int addressInt = ConvertTools.hexStrToInt(address);

        // 计算事务标识符
        int transactionIdentifier = addressInt + length;

        // 如果事务标识符超过了 32767，通过取模运算将其限制在 -32768 到 32767 的范围内
        if (transactionIdentifier > 32767) {
            transactionIdentifier = transactionIdentifier % 32768 - 32768;
        }

        // 返回事务标识符
        return (short) transactionIdentifier;
    }
}
