/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.config;

import java.util.Objects;

public class SocketSslConfig {
    private boolean enabled;
    private boolean verifyPeerCertificate;
    private boolean requireClientAuth;
    private String keyStorePath;
    private String keyStoreType = "JKS";
    private String keyStorePassword;
    private String keyPassword;
    private String trustStorePath;
    private String trustStoreType = "JKS";
    private String trustStorePassword;

    public boolean isEnabled() {
        return this.enabled;
    }

    public SocketSslConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isVerifyPeerCertificate() {
        return this.verifyPeerCertificate;
    }

    public SocketSslConfig setVerifyPeerCertificate(boolean verifyPeerCertificate) {
        this.verifyPeerCertificate = verifyPeerCertificate;
        return this;
    }

    public boolean isRequireClientAuth() {
        return this.requireClientAuth;
    }

    public SocketSslConfig setRequireClientAuth(boolean requireClientAuth) {
        this.requireClientAuth = requireClientAuth;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public SocketSslConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public SocketSslConfig setKeyStoreType(String keyStoreType) {
        if (keyStoreType != null && !keyStoreType.isBlank()) {
            this.keyStoreType = keyStoreType;
        }
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public SocketSslConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public SocketSslConfig setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public SocketSslConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public SocketSslConfig setTrustStoreType(String trustStoreType) {
        if (trustStoreType != null && !trustStoreType.isBlank()) {
            this.trustStoreType = trustStoreType;
        }
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public SocketSslConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public boolean hasKeyStore() {
        return this.keyStorePath != null && !this.keyStorePath.isBlank();
    }

    public boolean hasTrustStore() {
        return this.trustStorePath != null && !this.trustStorePath.isBlank();
    }

    public char[] keyStorePasswordChars() {
        if (this.keyStorePassword == null) {
            return new char[0];
        }
        return this.keyStorePassword.toCharArray();
    }

    public char[] keyPasswordChars() {
        if (this.keyPassword != null) {
            return this.keyPassword.toCharArray();
        }
        return this.keyStorePasswordChars();
    }

    public char[] trustStorePasswordChars() {
        if (this.trustStorePassword == null) {
            return new char[0];
        }
        return this.trustStorePassword.toCharArray();
    }

    public String identityKey() {
        return this.enabled + "-" + this.verifyPeerCertificate + "-" + this.requireClientAuth + "-" + this.keyStorePath + "-" + this.keyStoreType + "-" + this.trustStorePath + "-" + this.trustStoreType;
    }

    public String toString() {
        return "SocketSslConfig{enabled=" + this.enabled + ", verifyPeerCertificate=" + this.verifyPeerCertificate + ", requireClientAuth=" + this.requireClientAuth + ", keyStorePath='" + this.keyStorePath + "', trustStorePath='" + this.trustStorePath + "'}";
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.verifyPeerCertificate, this.requireClientAuth, this.keyStorePath, this.keyStoreType, this.trustStorePath, this.trustStoreType);
    }
}

