package com.af.v4.system.common.socket.core.client.tcp;

import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.ByteBufChannelHandler;
import com.af.v4.system.common.socket.core.ssl.SocketSslContextFactory;
import com.af.v4.system.common.socket.core.client.SocketClient;
import com.af.v4.system.common.socket.config.SocketSslConfig;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import jakarta.annotation.PreDestroy;
import io.netty.handler.ssl.SslContext;

/**
 * TCP客户端
 */
public class TcpClient extends SocketClient {
    private EventLoopGroup group;

    @Override
    protected Bootstrap initBootstrap(SocketClientConfigItem socketClientConfigItem) {
        Class<? extends Channel> channelClass;
        if (ApplicationService.getOSType() == OSType.LINUX) {
            group = new EpollEventLoopGroup();
            channelClass = EpollSocketChannel.class;
        } else {
            group = new NioEventLoopGroup();
            channelClass = NioSocketChannel.class;
        }

        SocketSslConfig sslConfig = socketClientConfigItem.getSslConfig();
        SocketClientConfigItem currentConfig = socketClientConfigItem;
        
        return new Bootstrap()
                .group(group)
                .channel(channelClass)
                .handler(new ChannelInitializer<SocketChannel>() {
                    @Override
                    protected void initChannel(SocketChannel ch) {
                        if (sslConfig != null && sslConfig.isEnabled()) {
                            try {
                                SslContext sslContext = SocketSslContextFactory.forClient(currentConfig.getName(), sslConfig);
                                ch.pipeline().addLast("ssl", sslContext.newHandler(ch.alloc(), currentConfig.getHost(), currentConfig.getPort()));
                            } catch (Exception e) {
                                LOGGER.error("初始化客户端 SSL 失败: {}", e.getMessage(), e);
                                ch.close();
                                return;
                            }
                        }
                        ch.pipeline().addLast(new ByteBufChannelHandler());
                    }
                });
    }

    @PreDestroy
    public void destroy() {
        if (group != null) {
            group.shutdownGracefully();
        }
    }

    @Override
    public void senMes(SocketClientConfigItem socketClientConfigItem) {
    }
}
