/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket;

import com.af.v4.system.common.socket.config.SocketConfig;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.config.SocketSslConfig;
import com.af.v4.system.common.socket.core.server.SocketServer;
import com.af.v4.system.common.socket.core.server.modbus.ModBusServer;
import com.af.v4.system.common.socket.core.server.mqtt.MqttServer;
import com.af.v4.system.common.socket.core.server.tcp.TcpServer;
import com.af.v4.system.common.socket.core.server.udp.UdpServer;
import com.af.v4.system.common.socket.core.ssl.SocketSslContextFactory;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import io.netty.channel.Channel;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SocketServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketServerManager.class);
    private static final Map<String, SocketConfigItem> socketConfigMap = new HashMap<String, SocketConfigItem>();
    private final SocketConfig socketConfig;
    private final List<SocketServer<?, ?>> socketServerList = new ArrayList();

    public SocketServerManager(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
    }

    public static SocketConfigItem getSocketConfigItemByPort(String port) {
        return socketConfigMap.get(port);
    }

    public static Optional<SocketConfigItem> getConfigItemByChannel(Channel ch) {
        try {
            String port = String.valueOf(((InetSocketAddress)ch.localAddress()).getPort());
            return Optional.ofNullable(socketConfigMap.get(port));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @PostConstruct
    public void startAll() {
        List<SocketConfigItem> socketConfigItemList = this.socketConfig.getSocketServerList();
        if (socketConfigItemList != null) {
            socketConfigItemList.forEach(item -> {
                if (item.getType() == SocketTypeEnum.TCP) {
                    this.logSslConfig((SocketConfigItem)item);
                }
                SocketServer<?, ?> socketServer = this.createSocketServer((SocketConfigItem)item);
                this.socketServerList.add(socketServer);
                item.getPorts().forEach(port -> socketConfigMap.put(port.toString(), (SocketConfigItem)item));
                if (socketServer != null) {
                    socketServer.run((SocketConfigItem)item);
                }
            });
        }
    }

    private void logSslConfig(SocketConfigItem item) {
        SocketSslConfig sslConfig = item.getSslConfig();
        if (sslConfig != null && sslConfig.isEnabled()) {
            if (sslConfig.hasKeyStore()) {
                List<String> keyAliases = SocketSslContextFactory.getCertificateAliases(sslConfig, true);
                LOGGER.info("\u670d\u52a1\u7aef[{}] SSL\u5df2\u542f\u7528 - \u5bc6\u94a5\u5e93\u8def\u5f84: {}, \u8bc1\u4e66\u522b\u540d: {}", new Object[]{item.getName(), sslConfig.getKeyStorePath(), keyAliases.isEmpty() ? "\u65e0" : String.join((CharSequence)", ", keyAliases)});
            }
            if (sslConfig.hasTrustStore()) {
                List<String> trustAliases = SocketSslContextFactory.getCertificateAliases(sslConfig, false);
                LOGGER.info("\u670d\u52a1\u7aef[{}] SSL\u5df2\u542f\u7528 - \u4fe1\u4efb\u5e93\u8def\u5f84: {}, \u8bc1\u4e66\u522b\u540d: {}", new Object[]{item.getName(), sslConfig.getTrustStorePath(), trustAliases.isEmpty() ? "\u65e0" : String.join((CharSequence)", ", trustAliases)});
            }
        } else {
            LOGGER.warn("\u670d\u52a1\u7aef[{}] SSL\u672a\u542f\u7528 - \u8fde\u63a5\u5c06\u4f7f\u7528\u660e\u6587\u4f20\u8f93\uff0c\u5b58\u5728\u5b89\u5168\u98ce\u9669", (Object)item.getName());
        }
    }

    private SocketServer<?, ?> createSocketServer(SocketConfigItem item) {
        SocketServer socketServer = null;
        if (item.getType() == SocketTypeEnum.TCP) {
            socketServer = new TcpServer();
        } else if (item.getType() == SocketTypeEnum.UDP) {
            socketServer = new UdpServer();
        } else if (item.getType() == SocketTypeEnum.MODBUS_TCP) {
            socketServer = new ModBusServer();
        } else if (item.getType() == SocketTypeEnum.MQTT) {
            socketServer = new MqttServer(item);
        }
        return socketServer;
    }

    @PreDestroy
    public void destroyAll() {
        for (SocketServer<?, ?> socketServer : this.socketServerList) {
            socketServer.destroy();
        }
    }
}

