package com.af.v4.system.common.socket.core.client.mqtt;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.handler.codec.mqtt.MqttMessage;
import org.jspecify.annotations.NonNull;

import java.util.concurrent.TimeUnit;

public class MQTTMessageContext {
    // 存放Qos2消息等级的消息ID，这里可使用redis之类的工具做持久化，为了简化开发，使用map暂存
    public static final Cache<@NonNull String, MqttMessage> MQTT_MESSAGE_ID_MAP;

    static {
        MQTT_MESSAGE_ID_MAP = Caffeine.newBuilder().expireAfterWrite(10, TimeUnit.MINUTES).build();
    }

    public static boolean hasKey(String messageId) {
        return MQTT_MESSAGE_ID_MAP.asMap().containsKey(messageId);
    }

    public static void put(String messageId, MqttMessage mqttMessage) {
        MQTT_MESSAGE_ID_MAP.put(messageId, mqttMessage);
    }

    public static void remove(String messageId) {
        MQTT_MESSAGE_ID_MAP.invalidate(messageId);
    }

    public static MqttMessage get(String messageId) {
        return MQTT_MESSAGE_ID_MAP.getIfPresent(messageId);
    }
}
