/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.ssl;

import com.af.v4.system.common.socket.config.SocketSslConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketSslContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketSslContextFactory.class);
    private static final Map<String, SslContext> SERVER_CACHE = new ConcurrentHashMap<String, SslContext>();
    private static final Map<String, SslContext> CLIENT_CACHE = new ConcurrentHashMap<String, SslContext>();

    private SocketSslContextFactory() {
    }

    public static SslContext forServer(String identifier, SocketSslConfig config) {
        SocketSslContextFactory.validateConfig(config);
        if (!config.hasKeyStore()) {
            throw new IllegalStateException("Server SSL \u9700\u8981\u914d\u7f6e keyStorePath");
        }
        String cacheKey = "server:" + identifier + ":" + config.identityKey();
        return SERVER_CACHE.computeIfAbsent(cacheKey, key -> SocketSslContextFactory.buildServerContext(config));
    }

    public static SslContext forClient(String identifier, SocketSslConfig config) {
        SocketSslContextFactory.validateConfig(config);
        String cacheKey = "client:" + identifier + ":" + config.identityKey();
        return CLIENT_CACHE.computeIfAbsent(cacheKey, key -> SocketSslContextFactory.buildClientContext(config));
    }

    private static void validateConfig(SocketSslConfig config) {
        if (config == null || !config.isEnabled()) {
            throw new IllegalStateException("\u672a\u5f00\u542f SSL");
        }
    }

    private static SslContext buildServerContext(SocketSslConfig config) {
        try {
            KeyManagerFactory kmf = SocketSslContextFactory.buildKeyManagerFactory(config);
            SslContextBuilder builder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
            if (config.isRequireClientAuth() && config.hasTrustStore()) {
                builder.trustManager(SocketSslContextFactory.buildTrustManagerFactory(config));
                builder.clientAuth(ClientAuth.REQUIRE);
            } else {
                builder.clientAuth(ClientAuth.NONE);
            }
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u670d\u52a1\u7aef SSL \u4e0a\u4e0b\u6587\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("\u6784\u5efa\u670d\u52a1\u7aef SSL \u4e0a\u4e0b\u6587\u5931\u8d25", e);
        }
    }

    private static SslContext buildClientContext(SocketSslConfig config) {
        try {
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (config.isVerifyPeerCertificate()) {
                if (!config.hasTrustStore()) {
                    throw new IllegalStateException("\u9700\u8981\u6821\u9a8c\u8bc1\u4e66\u65f6\u5fc5\u987b\u914d\u7f6e trustStorePath");
                }
                builder.trustManager(SocketSslContextFactory.buildTrustManagerFactory(config));
            } else {
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            if (config.hasKeyStore()) {
                builder.keyManager(SocketSslContextFactory.buildKeyManagerFactory(config));
            }
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u5ba2\u6237\u7aef SSL \u4e0a\u4e0b\u6587\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("\u6784\u5efa\u5ba2\u6237\u7aef SSL \u4e0a\u4e0b\u6587\u5931\u8d25", e);
        }
    }

    private static KeyManagerFactory buildKeyManagerFactory(SocketSslConfig config) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = SocketSslContextFactory.loadKeyStore(config.getKeyStorePath(), config.getKeyStoreType(), config.keyStorePasswordChars());
        kmf.init(keyStore, SocketSslContextFactory.passwordOrNull(config.keyPasswordChars()));
        return kmf;
    }

    private static TrustManagerFactory buildTrustManagerFactory(SocketSslConfig config) throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = SocketSslContextFactory.loadKeyStore(config.getTrustStorePath(), config.getTrustStoreType(), config.trustStorePasswordChars());
        tmf.init(trustStore);
        return tmf;
    }

    private static KeyStore loadKeyStore(String location, String type, char[] password) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        Objects.requireNonNull(location, "\u8bc1\u4e66\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        KeyStore keyStore = KeyStore.getInstance(type == null || type.isBlank() ? KeyStore.getDefaultType() : type);
        try (InputStream inputStream = SocketSslContextFactory.openInputStream(location);){
            keyStore.load(inputStream, SocketSslContextFactory.passwordOrNull(password));
        }
        return keyStore;
    }

    private static InputStream openInputStream(String location) throws IOException {
        if (location.startsWith("classpath:")) {
            String resource = location.substring("classpath:".length());
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (stream == null) {
                throw new IllegalStateException("classpath \u4e0b\u672a\u627e\u5230\u8bc1\u4e66: " + resource);
            }
            return stream;
        }
        return Files.newInputStream(Path.of(location, new String[0]), new OpenOption[0]);
    }

    private static char[] passwordOrNull(char[] original) {
        if (original == null || original.length == 0) {
            return null;
        }
        return original;
    }

    public static List<String> getCertificateAliases(SocketSslConfig config, boolean isKeyStore) {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            char[] password;
            String storePath = isKeyStore ? config.getKeyStorePath() : config.getTrustStorePath();
            String storeType = isKeyStore ? config.getKeyStoreType() : config.getTrustStoreType();
            char[] cArray = password = isKeyStore ? config.keyStorePasswordChars() : config.trustStorePasswordChars();
            if (storePath == null || storePath.isBlank()) {
                return aliases;
            }
            KeyStore keyStore = SocketSslContextFactory.loadKeyStore(storePath, storeType, password);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                aliases.add(enumeration.nextElement());
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u8bc1\u4e66\u522b\u540d\u5931\u8d25: {}", (Object)e.getMessage());
        }
        return aliases;
    }
}

