package com.af.v4.system.common.socket.core.server.tcp;

import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.config.SocketSslConfig;
import com.af.v4.system.common.socket.core.channel.impl.ByteBufChannelHandler;
import com.af.v4.system.common.socket.core.ssl.SocketSslContextFactory;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;

/**
 * TCP服务端
 */
public class TcpServer extends AbstractTcpServer {

    @Override
    protected void setChildHandler(SocketChannel ch) {
        SocketConfigItem configItem = SocketServerManager.getConfigItemByChannel(ch).orElse(null);
        SocketSslConfig sslConfig = configItem == null ? null : configItem.getSslConfig();
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                SslContext sslContext = SocketSslContextFactory.forServer(configItem.getName(), sslConfig);
                ch.pipeline().addLast("ssl", sslContext.newHandler(ch.alloc()));
            } catch (Exception e) {
                LOGGER.error("初始化服务端 SSL 失败: {}", e.getMessage(), e);
                ch.close();
                return;
            }
        }
        ch.pipeline().addLast(businessGroup, new ByteBufChannelHandler());
    }

    @Override
    protected void destroyOtherGroup() {

    }
}
