package com.af.v4.system.common.socket.config;

import com.af.v4.system.common.socket.enums.MsgTypeEnum;

/**
 * ModbusEvent
 *
 * @author 张振宇
 */
public class ClientEvent {
    private String remark;
    private String address;
    private int functionCode;
    private short transactionId;
    private int length;
    private String alias;
    private int time;
    private String logicName;

    private MsgTypeEnum decodeType;

    public String getRemark() {
        return remark;
    }

    public ClientEvent setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getAddress() {
        return address;
    }

    public ClientEvent setAddress(String address) {
        this.address = address;
        return this;
    }

    public int getFunctionCode() {
        return functionCode;
    }

    public ClientEvent setFunctionCode(int functionCode) {
        this.functionCode = functionCode;
        return this;
    }

    public int getLength() {
        return length;
    }

    public ClientEvent setLength(int length) {
        this.length = length;
        return this;
    }

    public String getAlias() {
        return alias;
    }

    public ClientEvent setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public int getTime() {
        return time;
    }

    public ClientEvent setTime(int time) {
        this.time = time;
        return this;
    }

    public String getLogicName() {
        return logicName;
    }

    public ClientEvent setLogicName(String logicName) {
        this.logicName = logicName;
        return this;
    }

    public short getTransactionId() {
        return transactionId;
    }

    public ClientEvent setTransactionId(short transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public MsgTypeEnum getDecodeType() {
        return decodeType;
    }

    public ClientEvent setDecodeType(MsgTypeEnum decodeType) {
        this.decodeType = decodeType;
        return this;
    }

    @Override
    public String toString() {
        return STR."Event{remark='\{remark}', address='\{address}', functionCode=\{functionCode}, length=\{length}, alias='\{alias}', time=\{time}, logicName='\{logicName}', transactionId='\{transactionId}'}";
    }
}
