package com.af.v4.system.common.socket.core.server.mqtt;

import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.MqttServerChannelHandler;
import com.af.v4.system.common.socket.core.server.tcp.AbstractTcpServer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;

public class MqttServer extends AbstractTcpServer {
    // 设置最大消息大小为 256KB
    private static final int MAX_INCOMING_MESSAGE_SIZE = 1024 * 256;
    private final SocketConfigItem configItem;

    public MqttServer(SocketConfigItem configItem) {
        this.configItem = configItem;
    }


    @Override
    protected void setChildHandler(SocketChannel ch){
        ch.pipeline()
                .addLast("encoder", MqttEncoder.INSTANCE)
                .addLast("decoder", new MqttDecoder(MAX_INCOMING_MESSAGE_SIZE))
                .addLast(new MqttServerChannelHandler(configItem));
    }

    @Override
    protected boolean useKeepAlive() {
        return false;
    }

    @Override
    protected void destroyOtherGroup() {

    }
}
