package com.af.v4.system.common.socket.config;

import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import org.json.JSONArray;

/**
 * Socket服务端
 *
 * @author Mr.river
 */
public class SocketConfigItem {

    /**
     * 服务端类型(tcp,udp)
     */
    private SocketTypeEnum type;
    /**
     * 服务端名称
     */
    private String name;
    /**
     * 监听端口集合
     */
    private JSONArray ports;
    /**
     * 接收数据的logic名称
     */
    private String logicName;
    /**
     * 编码类型
     */
    private MsgTypeEnum encodeType;
    /**
     * 解码类型
     */
    private MsgTypeEnum decodeType;
    /**
     * mqtt服务器用户名
     */
    private String username;

    /**
     * mqtt服务器密码
     */
    private String password;

    /**
     * 空闲超时秒数（0 表示不启用），默认 60
     */
    private Integer idleSeconds;

    /**
     * 是否开启 DEBUG 级网络日志
     */
    private Boolean debugLogging;

    public SocketTypeEnum getType() {
        return type;
    }

    public SocketConfigItem setType(SocketTypeEnum type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return name;
    }

    public SocketConfigItem setName(String name) {
        this.name = name;
        return this;
    }

    public JSONArray getPorts() {
        return ports;
    }

    public SocketConfigItem setPorts(JSONArray ports) {
        this.ports = ports;
        return this;
    }

    public String getLogicName() {
        return logicName;
    }

    public SocketConfigItem setLogicName(String logicName) {
        this.logicName = logicName;
        return this;
    }

    public MsgTypeEnum getEncodeType() {
        return encodeType;
    }

    public SocketConfigItem setEncodeType(MsgTypeEnum encodeType) {
        this.encodeType = encodeType;
        return this;
    }

    public MsgTypeEnum getDecodeType() {
        return decodeType;
    }

    public SocketConfigItem setDecodeType(MsgTypeEnum decodeType) {
        this.decodeType = decodeType;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public SocketConfigItem setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return password;
    }

    public SocketConfigItem setPassword(String password) {
        this.password = password;
        return this;
    }

    public Integer getIdleSeconds() {
        return idleSeconds;
    }

    public SocketConfigItem setIdleSeconds(Integer idleSeconds) {
        this.idleSeconds = idleSeconds;
        return this;
    }

    public Boolean getDebugLogging() {
        return debugLogging;
    }

    public SocketConfigItem setDebugLogging(Boolean debugLogging) {
        this.debugLogging = debugLogging;
        return this;
    }
}
