package com.af.v4.system.common.socket.core.server.modbus;

import com.af.v4.system.common.socket.core.channel.impl.ModbusTCPChannelHandler;
import com.af.v4.system.common.socket.core.decoder.ModbusRequestDecoder;
import com.af.v4.system.common.socket.core.encoder.ModbusResponseEncoder;
import com.af.v4.system.common.socket.core.server.tcp.AbstractTcpServer;
import io.netty.channel.socket.SocketChannel;

/**
 * ModBus服务端
 */
public class ModBusServer extends AbstractTcpServer {

    @Override
    protected void setChildHandler(SocketChannel ch) {
        ch.pipeline()
                .addLast(new ModbusRequestDecoder())
                .addLast(new ModbusResponseEncoder())
                .addLast(businessGroup, new ModbusTCPChannelHandler());
    }

    @Override
    protected void destroyOtherGroup() {

    }
}
