package com.af.v4.system.common.socket.core.client.mqtt;

import cn.hutool.cache.impl.TimedCache;
import io.netty.handler.codec.mqtt.MqttMessage;

import java.util.concurrent.ConcurrentHashMap;

public class MQTTMessageContext {
    // 存放Qos2消息等级的消息ID，这里可使用redis之类的工具做持久化，为了简化开发，使用map暂存
    public static final TimedCache<String, MqttMessage> MQTT_MESSAGE_ID_MAP;

    static {
        MQTT_MESSAGE_ID_MAP = new TimedCache<>(1000 * 60 * 10, new ConcurrentHashMap<>());
    }

    public static boolean hasKey(String messageId) {
        return MQTT_MESSAGE_ID_MAP.containsKey(messageId);
    }

    public static void put(String messageId, MqttMessage mqttMessage) {
        MQTT_MESSAGE_ID_MAP.put(messageId, mqttMessage);
    }

    public static void remove(String messageId) {
        MQTT_MESSAGE_ID_MAP.remove(messageId);
    }

    public static MqttMessage get(String messageId) {
        return MQTT_MESSAGE_ID_MAP.get(messageId);
    }
}
