/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.channel.mqtt.MqttMsgBack;
import com.af.v4.system.common.socket.core.client.ChannelManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MqttServerChannelHandler
extends AbstractChannelHandler<MqttMessage> {
    private final Logger log = LoggerFactory.getLogger(MqttServerChannelHandler.class);
    private final SocketConfigItem configItem;

    public MqttServerChannelHandler(SocketConfigItem configItem) {
        this.configItem = configItem;
    }

    @Override
    protected void read(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        if (null != mqttMessage) {
            MqttMsgBack mqttMsgBack = new MqttMsgBack();
            this.log.info("info--{}", (Object)mqttMessage);
            MqttFixedHeader mqttFixedHeader = mqttMessage.fixedHeader();
            Channel channel = ctx.channel();
            switch (mqttFixedHeader.messageType()) {
                case CONNECT: {
                    mqttMsgBack.connect(channel, mqttMessage, this.configItem, ChannelManager.getChannelMap().contains(channel));
                    break;
                }
                case PUBLISH: {
                    mqttMsgBack.puback(channel, mqttMessage);
                    String topic = ((MqttPublishVariableHeader)mqttMessage.variableHeader()).topicName();
                    JSONObject address = new JSONObject().put("topic", (Object)topic).put("remoteAddress", (Object)channel.remoteAddress().toString());
                    this.runBusiness((ByteBuf)mqttMessage.payload(), address.toString());
                    break;
                }
                case PUBREL: {
                    MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)mqttMessage.variableHeader();
                    if (ChannelManager.mqttMessageIdMap.containsKey(variableHeader.messageId())) {
                        this.log.warn("\u79fb\u9664\u6d88\u606f\u7f13\u5b58-->\u6d88\u606fid{}", (Object)variableHeader.messageId());
                        mqttMsgBack.subscribSend(ChannelManager.mqttMessageIdMap.get(variableHeader.messageId()));
                        mqttMsgBack.pubcomp(channel, mqttMessage);
                        ChannelManager.mqttMessageIdMap.remove(variableHeader.messageId());
                        break;
                    }
                    mqttMsgBack.pubcomp(channel, mqttMessage);
                    break;
                }
                case SUBSCRIBE: {
                    mqttMsgBack.suback(channel, mqttMessage);
                    mqttMsgBack.sub(channel, mqttMessage);
                    break;
                }
                case UNSUBSCRIBE: {
                    mqttMsgBack.unsuback(channel, mqttMessage);
                    mqttMsgBack.unSub(channel, mqttMessage);
                    break;
                }
                case PINGREQ: {
                    mqttMsgBack.pingresp(channel, mqttMessage);
                    break;
                }
                case DISCONNECT: {
                    mqttMsgBack.disconnack(channel);
                    break;
                }
            }
        }
    }
}

