/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel;

import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.log.enums.OperatorType;
import com.af.v4.system.common.log.service.LogResolveService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelHandler<T>
extends SimpleChannelInboundHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractChannelHandler.class);

    protected final void channelRead0(ChannelHandlerContext ctx, T msg) {
        String channelId = ctx.channel().id().asLongText();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("channelId:{}, \u6536\u5230\u6d88\u606f", (Object)channelId);
        }
        ScopedValue.where(ClientManager.getChannelScopedValue(), channelId).run(() -> {
            if (ClientManager.getChannelData() == null) {
                this.initChannelData(ctx);
            }
            this.read(ctx, msg);
        });
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String channelId = ctx.channel().id().asLongText();
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        String address = socketAddress == null ? "-" : socketAddress.toString();
        LOGGER.info("channelId:{}, address:{}, \u6210\u529f\u5efa\u7acb\u8fde\u63a5", (Object)channelId, (Object)address);
        this.initChannelData(ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.warn("channelId:{}, \u89e6\u53d1\u65ad\u7ebf", (Object)ctx.channel().id().asLongText());
        if (!(ctx.channel() instanceof DatagramChannel)) {
            try {
                ctx.close();
            }
            catch (Exception e) {
                LOGGER.error("\u5173\u95ed\u901a\u9053\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        super.channelInactive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            IdleState state = idleStateEvent.state();
            LOGGER.warn("channelId:{}, \u89e6\u53d1\u7a7a\u95f2\u4e8b\u4ef6:{}", (Object)ctx.channel().id().asLongText(), (Object)state);
            if (!(ctx.channel() instanceof DatagramChannel)) {
                ctx.close();
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String channelId = ctx.channel().id().asLongText();
        LOGGER.error("channelId:{} \u53d1\u751f\u5f02\u5e38", (Object)channelId, (Object)cause);
        try {
            String plain = "ERROR:" + cause.getMessage();
            ScopedValue.where(ClientManager.getChannelScopedValue(), channelId).run(() -> {
                MsgTypeEnum encodeType = ClientManager.getConfig().getEncodeType();
                String payload = switch (encodeType) {
                    case MsgTypeEnum.HEX -> ConvertTools.byteToHexStr((byte[])plain.getBytes(StandardCharsets.UTF_8));
                    case MsgTypeEnum.BASE64 -> ConvertTools.base64Encode((byte[])plain.getBytes(StandardCharsets.UTF_8));
                    case MsgTypeEnum.HEX_BASE64 -> {
                        String b64 = ConvertTools.base64Encode((byte[])plain.getBytes(StandardCharsets.UTF_8));
                        yield ConvertTools.byteToHexStr((byte[])b64.getBytes(StandardCharsets.UTF_8));
                    }
                    default -> plain;
                };
                ClientManager.send(payload);
            });
        }
        catch (Exception sendEx) {
            LOGGER.warn("\u5f02\u5e38\u901a\u77e5\u53d1\u9001\u5931\u8d25, channelId:{}", (Object)channelId, (Object)sendEx);
        }
        finally {
            if (!(ctx.channel() instanceof DatagramChannel)) {
                try {
                    ctx.close();
                }
                catch (Exception e) {
                    LOGGER.error("\u5f02\u5e38\u5904\u7406\u9636\u6bb5\u5173\u95ed\u901a\u9053\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    protected abstract void read(ChannelHandlerContext var1, T var2);

    private void initChannelData(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        String port = String.valueOf(((InetSocketAddress)channel.localAddress()).getPort());
        SocketConfigItem configItem = SocketServerManager.getSocketConfigItemByPort(port);
        ClientManager.add(channel.id().asLongText(), new ChannelData(configItem, channel, new JSONObject()));
    }

    protected Object runBusiness(ByteBuf content, String remoteAddress) {
        String realData;
        long beginTime = System.currentTimeMillis();
        SocketConfigItem configItem = ClientManager.getConfig();
        byte[] data = new byte[content.readableBytes()];
        content.readBytes(data);
        try {
            realData = switch (configItem.getDecodeType()) {
                case MsgTypeEnum.HEX -> ConvertTools.byteToHexStr((byte[])data);
                default -> ConvertTools.bytesToStr((byte[])data);
            };
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
        JSONObject params = new JSONObject();
        params.put("value", (Object)realData);
        params.put("address", (Object)remoteAddress);
        try {
            Object result = ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run(configItem.getLogicName(), params);
            long endTime = System.currentTimeMillis();
            this.handleLog(configItem.getLogicName(), params, null, endTime - beginTime);
            return result;
        }
        catch (Exception e) {
            if (e instanceof LogicException) {
                LogicException ex = (LogicException)e;
                LOGGER.error("\u8bf7\u6c42\u6765\u6e90'{}',\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38.\n{}", (Object)remoteAddress, (Object)ex.getStack());
            } else {
                LOGGER.error("\u8bf7\u6c42\u6765\u6e90'{}',\u53d1\u751f\u670d\u52a1\u7aef\u5f02\u5e38.", (Object)remoteAddress, (Object)e);
            }
            long endTime = System.currentTimeMillis();
            this.handleLog(configItem.getLogicName(), params, e, endTime - beginTime);
            throw e;
        }
    }

    protected void handleLog(String logicName, Object operParams, Throwable e, long costTime) {
        ((LogResolveService)SpringUtils.getBean(LogResolveService.class)).resolveLog(((Object)((Object)this)).getClass().getName(), "runBusiness", BusinessType.LOGIC.name(), "Socket\u8c03\u7528Logic\uff1a" + logicName, OperatorType.SYSTEM.name(), operParams.toString(), costTime, e);
    }
}

