/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.proxy.liuli.ILiuLiConfigServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Element;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Component
public class PluginMapper
extends AbstractResourceMapper<PluginResource> {
    private static Map<String, Object> pluginMap;

    protected PluginMapper(ModuleMapper moduleMapper, ApplicationService applicationService, ILiuLiConfigServiceProxy liuLiConfigServiceProxy) {
        super(moduleMapper, applicationService, liuLiConfigServiceProxy);
    }

    public Map<String, Object> getPluginMap() {
        return pluginMap;
    }

    @Override
    protected void loadMap() {
        super.loadMap();
        pluginMap = this.getAllMap().entrySet().stream().filter(object -> ((PluginResource)object.getValue()).getObj() != null).collect(Collectors.toMap(Map.Entry::getKey, object -> ((PluginResource)object.getValue()).getObj()));
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.PLUGIN;
    }

    @Override
    public String getFileName() {
        return "plugins.xml";
    }

    @Override
    public String getFolderName() {
        return null;
    }

    @Override
    protected boolean isBinaryResource() {
        return true;
    }

    @Override
    public boolean isSupportCompile() {
        return false;
    }

    @Override
    protected String getResPath(Element element, String moduleName, String parentModuleName) {
        return element.attribute("class").getValue();
    }

    @Override
    protected PluginResource buildResourceImpl(String moduleName, String key, String path, JSONObject liuliValue, Map<String, Object> attrMap) {
        Object className = attrMap.get("class");
        return new PluginResource(this, moduleName, key, path, this.getObjByClassName(className.toString(), moduleName));
    }

    private Object getObjByClassName(String className, String moduleName) {
        try {
            Class<?> c = Class.forName(className);
            Object obj = this.isSpringBean(c) ? SpringUtils.getBean(c) : c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            if (moduleName == null) {
                moduleName = "/";
            }
            LOGGER.warn("\u672a\u627e\u5230\u63d2\u4ef6, \u6240\u5c5e\u6a21\u5757: {}, \u8def\u5f84: {}", (Object)moduleName, (Object)ex.getMessage());
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isSpringBean(Class<?> c) {
        for (Annotation annotation : c.getAnnotations()) {
            if (annotation.annotationType() != Component.class && annotation.annotationType() != Service.class && annotation.annotationType() != Controller.class && annotation.annotationType() != RestController.class) continue;
            return true;
        }
        return false;
    }

    public static class PluginResource
    extends AbstractResourceMapper.CommonResource {
        private final Object obj;

        public PluginResource(AbstractResourceMapper<?> mapper, String moduleName, String key, String path, Object obj) {
            super(mapper, moduleName, key, path, null);
            this.obj = obj;
        }

        public Object getObj() {
            return this.obj;
        }
    }
}

