package com.af.v4.system.common.resource.enums;

import java.util.stream.Stream;

/**
 * 资源类型
 *
 * @author Mr.river
 */
public enum ResourceType {
    /**
     * LOGIC文件
     */
    LOGIC("logic"),
    /**
     * SQL文件
     */
    SQL("sql"),
    /**
     * Plugin文件
     */
    PLUGIN("plugin"),
    /**
     * 报表文件
     */
    REPORT("report");

    private final String value;

    ResourceType(String value) {
        this.value = value;
    }

    public static ResourceType toType(String value) {
        return Stream.of(ResourceType.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }


    @Override
    public String toString() {
        return getValue();
    }
}
