/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.redis.core;

import com.af.v4.system.common.redis.core.FastCacheQueueManager;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.json.JSONObject;

public class ConsumerRegistration {
    final String queueName;
    Function<JSONObject, Object> onProcess;
    BiConsumer<JSONObject, Object> onSuccess;
    BiConsumer<JSONObject, Exception> onFailure;
    BiConsumer<JSONObject, JSONObject> beforeRetry;
    boolean requeueOnFailure = false;
    Predicate<JSONObject> filter;
    BiPredicate<JSONObject, Exception> condition;
    int defaultMaxRetries = 3;
    boolean verbose = true;

    public ConsumerRegistration(String queueName) {
        this.queueName = queueName;
    }

    public ConsumerRegistration filter(Predicate<JSONObject> predicate) {
        this.filter = predicate;
        return this;
    }

    public ConsumerRegistration condition(BiPredicate<JSONObject, Exception> predicate) {
        this.condition = predicate;
        return this;
    }

    public ConsumerRegistration onProcess(Function<JSONObject, Object> handler) {
        this.onProcess = handler;
        return this;
    }

    public ConsumerRegistration onSuccess(BiConsumer<JSONObject, Object> handler) {
        this.onSuccess = handler;
        return this;
    }

    public ConsumerRegistration onFailure(BiConsumer<JSONObject, Exception> handler) {
        this.onFailure = handler;
        return this;
    }

    public ConsumerRegistration beforeRetry(BiConsumer<JSONObject, JSONObject> handler) {
        this.beforeRetry = handler;
        return this;
    }

    public ConsumerRegistration requeueOnFailure(boolean enable) {
        this.requeueOnFailure = enable;
        return this;
    }

    public ConsumerRegistration maxRetries(int max) {
        this.defaultMaxRetries = max;
        return this;
    }

    public ConsumerRegistration verbose(boolean enable) {
        this.verbose = enable;
        return this;
    }

    public void registerWith(FastCacheQueueManager manager, int threads) {
        for (int i = 1; i <= threads; ++i) {
            manager.register(this.queueName, i, this);
        }
    }
}

