package com.af.v4.system.common.redis.exception;

/**
 * 自定义异常：表示在指定等待时间内未能获取到锁。
 * 通常用于非阻塞锁场景（如 tryLock）超时失败时抛出。
 */
public class LockTimeoutException extends Exception {

    /**
     * 构造函数，包含异常信息
     *
     * @param message 异常描述
     */
    public LockTimeoutException(String message) {
        super(message);
    }

    /**
     * 构造函数，包含异常信息和原始异常
     *
     * @param message 异常描述
     * @param cause   原始异常
     */
    public LockTimeoutException(String message, Throwable cause) {
        super(message, cause);
    }
}
