/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core;

import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.core.response.AsyncResponse;
import com.af.v4.system.common.plugins.http.core.response.DefaultAsyncResponse;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAsyncConnectionPoolUtil
extends BaseHttpPoolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAsyncConnectionPoolUtil.class);
    private static final String HTTP_CLIENT_KEY = "http";
    private static final Map<String, CloseableHttpAsyncClient> CLIENT_MAP = new ConcurrentHashMap<String, CloseableHttpAsyncClient>(3);

    private static CloseableHttpAsyncClient createHttpClient(String clientKey, TlsStrategy strategy) {
        return CLIENT_MAP.computeIfAbsent(clientKey, key -> {
            TlsStrategy realTlsStrategy;
            HttpClientConfig config = new HttpClientConfig.Builder().build();
            if (strategy == null) {
                try {
                    realTlsStrategy = new DefaultClientTlsStrategy(SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build(), HostnameVerificationPolicy.CLIENT, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            } else {
                realTlsStrategy = strategy;
            }
            PoolingAsyncClientConnectionManager manager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(realTlsStrategy).setMaxConnTotal(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue()).setMaxConnPerRoute(HttpClientConfig.HTTP_MAX_ROUTE_SIZE.intValue()).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)config.getConnectTimeout().intValue())).build()).build();
            return HttpAsyncClients.custom().setKeepAliveStrategy((response, context) -> {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = (HeaderElement)it.next();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                    try {
                        return TimeValue.ofSeconds((long)Long.parseLong(value));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                return TimeValue.ofSeconds((long)5L);
            }).setConnectionManager((AsyncClientConnectionManager)manager).setIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Math.max(2, Runtime.getRuntime().availableProcessors())).setSoKeepAlive(true).build()).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(0, TimeValue.ZERO_MILLISECONDS)).evictExpiredConnections().evictIdleConnections(TimeValue.ofMilliseconds((long)HttpClientConfig.HTTP_IDEL_TIME_OUT.intValue())).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)config.getSocketTimeout().intValue())).build()).build();
        });
    }

    public static CloseableHttpAsyncClient getHttpClient(String tlsName, TlsStrategy strategy) {
        String clientKeyName = strategy == null ? HTTP_CLIENT_KEY : tlsName;
        CloseableHttpAsyncClient client = HttpAsyncConnectionPoolUtil.createHttpClient(clientKeyName, strategy);
        client.start();
        return client;
    }

    public static CloseableHttpAsyncClient getHttpClient() {
        return HttpAsyncConnectionPoolUtil.getHttpClient(null, null);
    }

    public static void request(String value, String headersStr, HttpClientConfig config, SimpleHttpRequest base, Boolean isStandardResponse, CloseableHttpAsyncClient httpClient, AsyncResponse futureCallback) {
        if (httpClient == null) {
            httpClient = HttpAsyncConnectionPoolUtil.getHttpClient();
        }
        if (futureCallback == null) {
            futureCallback = new DefaultAsyncResponse();
        }
        HttpAsyncConnectionPoolUtil.setRequestConfig(config, base);
        HttpAsyncConnectionPoolUtil.setHeaders((HttpRequest)base, headersStr);
        if (base.getBody() == null) {
            HttpAsyncConnectionPoolUtil.setBody((HttpRequest)base, value);
        }
        String url = base.getScheme() + "://" + String.valueOf(base.getAuthority()) + base.getPath();
        futureCallback.setContext(url, headersStr, value, isStandardResponse);
        httpClient.execute(base, (FutureCallback)futureCallback);
    }
}

