package com.af.v4.system.common.plugins.http;

import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.core.HttpAsyncConnectionPoolUtil;
import com.af.v4.system.common.plugins.http.core.response.AsyncResponse;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.json.JSONObject;

/**
 * HTTP异步请求工具类
 *
 * @author Mr.river
 */
public class RestAsyncTools {

    /**
     * 发送通用异步Http请求
     *
     * @param value              请求参数
     * @param headers            请求头
     * @param config             HttpClient配置文件
     * @param isStandardResponse 是否是标准响应（返回响应body和header）
     * @param base               请求类型
     * @param futureCallback     异步回调处理函数
     */
    public static void request(String value, String headers, HttpClientConfig config, SimpleHttpRequest base, Boolean isStandardResponse, AsyncResponse futureCallback) {
        JSONObject headerJson = BaseHttpPoolUtil.buildHeader(headers);
        HttpAsyncConnectionPoolUtil.request(value, headerJson.toString(), config, base, isStandardResponse, null, futureCallback);
    }

    public static void request(String value, String headers, HttpClientConfig config, SimpleHttpRequest base, AsyncResponse futureCallback) {
        HttpAsyncConnectionPoolUtil.request(value, headers, config, base, false, null, futureCallback);
    }

    /**
     * 发送post请求
     *
     * @param path               请求路径
     * @param value              请求体
     * @param headers            请求头
     * @param isStandardResponse 是否是标准响应（返回响应body和header）
     * @param futureCallback     异步回调接口
     */
    public static void post(String path, String value, String headers, Boolean isStandardResponse, AsyncResponse futureCallback) {
        request(value, headers, null, SimpleRequestBuilder.post(path).build(), isStandardResponse, futureCallback);
    }

    public static void post(String path, String value, String headers, AsyncResponse futureCallback) {
        post(path, value, headers, false, futureCallback);
    }

    public static void post(String path, JSONObject value) {
        post(path, value == null ? null : value.toString(), null, false, null);
    }

    /**
     * 发送get请求
     *
     * @param path               请求路径
     * @param headers            请求头
     * @param isStandardResponse 是否是标准响应（返回响应body和header）
     * @param futureCallback     异步回调接口
     */
    public static void get(String path, String headers, Boolean isStandardResponse, AsyncResponse futureCallback) {
        request(null, headers, null, SimpleRequestBuilder.get(path).build(), isStandardResponse, futureCallback);
    }

    public static void get(String path, String headers, AsyncResponse futureCallback) {
        request(null, headers, null, SimpleRequestBuilder.get(path).build(), false, futureCallback);
    }

    public static void get(String path) {
        get(path, null, false, null);
    }

    /**
     * 发送put请求
     *
     * @param path               请求路径
     * @param value              请求体
     * @param headers            请求头
     * @param isStandardResponse 是否是标准响应（返回响应body和header）
     * @param futureCallback     异步回调接口
     */
    public static void put(String path, String value, String headers, Boolean isStandardResponse, AsyncResponse futureCallback) {
        request(value, headers, null, SimpleRequestBuilder.put(path).build(), isStandardResponse, futureCallback);
    }

    public static void put(String path, JSONObject value, AsyncResponse futureCallback) {
        put(path, value == null ? null : value.toString(), null, false, futureCallback);
    }

    public static void put(String path, JSONObject value) {
        put(path, value == null ? null : value.toString(), null, false, null);
    }

    /**
     * 发送delete请求
     *
     * @param path               请求路径
     * @param value              请求体
     * @param headers            请求头
     * @param isStandardResponse 是否是标准响应（返回响应body和header）
     * @param futureCallback     异步回调接口
     */
    public static void delete(String path, String value, String headers, Boolean isStandardResponse, AsyncResponse futureCallback) {
        request(value, headers, null, SimpleRequestBuilder.delete(path).build(), isStandardResponse, futureCallback);
    }

    public static void delete(String path, String value, String headers, AsyncResponse futureCallback) {
        request(value, headers, null, SimpleRequestBuilder.delete(path).build(), false, futureCallback);
    }

    public static void delete(String path, JSONObject value) {
        delete(path, value == null ? null : value.toString(), null, false, null);
    }
}
