package com.af.v4.system.common.plugins.idea.gen;

import com.af.v4.system.common.plugins.idea.entity.Template;
import com.af.v4.system.common.plugins.idea.entity.TemplateGroup;
import com.af.v4.system.common.plugins.idea.entity.Variable;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;

/**
 * 模板插件生成
 */
public class TemplatePlugin {

    public static final List<TemplateGroup> TEMPLATE_GROUP_LIST;

    static {
        //core
        List<Template> coreTemplates = new ArrayList<>();
        //core-log
        coreTemplates.add(new Template("log.debug(日志内容)", "log.debug($str$)", "打印debug级别日志，返回: void",
                new Variable("str", String.class)));
        coreTemplates.add(new Template("log.info(日志内容)", "log.info($str$)", "打印info级别日志，返回: void",
                new Variable("str", String.class)));
        coreTemplates.add(new Template("log.warn(日志内容)", "log.warn($str$)", "打印warn级别日志，返回: void",
                new Variable("str", String.class)));
        coreTemplates.add(new Template("log.error(日志内容)", "log.error($str$)", "打印error级别日志，返回: void",
                new Variable("str", String.class)));
        //core-logic
        coreTemplates.add(new Template("logic.run(业务逻辑映射名, 执行参数)", "logic.run($name$, $params$)", "执行业务逻辑，返回: Object(执行结果)",
                new Variable("name", String.class),
                new Variable("params", JSONObject.class)));
        coreTemplates.add(new Template("logic.run(业务逻辑映射名, 执行参数, 数据源名称)", "logic.run($name$, $params$, $dataSource$)", "执行业务逻辑，返回: Object(执行结果)",
                new Variable("name", String.class),
                new Variable("params", JSONObject.class),
                new Variable("dataSource", String.class)));
        coreTemplates.add(new Template("logic.runAsync(业务逻辑映射名, 执行参数)", "logic.runAsync($name$, $params$)", "异步执行业务逻辑，返回: CompletableFuture<Object>",
                new Variable("name", String.class),
                new Variable("params", JSONObject.class)));
        coreTemplates.add(new Template("logic.remoteRun(服务名, 业务逻辑映射名, 执行参数)", "logic.remoteRun($serviceName$, $name$, $params$)", "远程调用业务逻辑，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("name", String.class),
                new Variable("params", JSONObject.class)));
        //core-sql
        coreTemplates.add(new Template("sql.query(SQL映射名, 执行参数)", "sql.query($name$, $params$)", "根据SQL文件执行查询，返回: JSONArray(结果集)",
                new Variable("name", String.class),
                new Variable("param", JSONObject.class)));
        coreTemplates.add(new Template("sql.query(SQL映射名, 执行参数, 每页数量)", "sql.query($name$, $params$, $pageSize$)", "根据SQL文件执行查询，返回: JSONArray(结果集)",
                new Variable("name", String.class),
                new Variable("param", JSONObject.class),
                new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.query(SQL映射名, 执行参数, 查询页码, 每页数量)", "sql.query($name$, $params$, $pageNo$, $pageSize$)", "根据SQL文件执行查询，返回: JSONArray(结果集)",
                new Variable("name", String.class),
                new Variable("param", JSONObject.class),
                new Variable("pageNo", Integer.class),
                new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.querySQL(SQL标识名, SQL语句)", "sql.querySQL($name$, $sql$)", "根据SQL语句执行查询，返回: JSONArray(结果集)",
                new Variable("name", String.class),
                new Variable("sql", String.class)));
        coreTemplates.add(new Template("sql.querySQL(SQL标识名, SQL语句, 每页数量)", "sql.querySQL($name$, $sql$, $pageSize$)", "根据SQL语句执行查询，返回: JSONArray(结果集)",
                new Variable("name", String.class),
                new Variable("sql", String.class),
                new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.querySQL(SQL标识名, SQL语句, 查询页码, 每页数量)", "sql.querySQL($name$, $sql$, $pageNo$, $pageSize$)", "根据SQL语句执行查询，返回: JSONArray(结果集)",
                new Variable("name", String.class),
                new Variable("sql", String.class),
                new Variable("pageNo", Integer.class),
                new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.exec(SQL映射名, 执行参数)", "sql.exec($name$, $params$)", "根据SQL文件执行增删改，返回: Integer(影响行数)",
                new Variable("name", String.class),
                new Variable("param", JSONObject.class)));
        coreTemplates.add(new Template("sql.execSQL(SQL标识名, SQL语句)", "sql.execSQL($name$, $sql$)", "根据SQL文件执行增删改，返回: Integer(影响行数)",
                new Variable("name", String.class),
                new Variable("param", String.class)));
        coreTemplates.add(new Template("sql.getDbTypeName()", "sql.getDbTypeName()", "获取数据库类型，返回: String(数据库类型)"));
        coreTemplates.add(new Template("sql.resolveSQL(SQL集合)", "sql.resolveSQL($sqlList$)", "解析符合数据源的SQL，返回: String(SQL语句)",
                new Variable("sqlList", JSONObject.class)));
        //core-entity
        coreTemplates.add(new Template("entity.getCondition()", "entity.getCondition()", "生成查询表达式，返回: Condition(af-common-jpa.utils.Condition)"));
        coreTemplates.add(new Template("entity.getById(列字段, 实体名, 主键值)", "entity.getById($column$, $entityName$, $id$)", "根据主键查询数据，返回: JSONObject(实体)",
                new Variable("column", String.class),
                new Variable("entityName", String.class),
                new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.getById(实体名, 主键值)", "entity.getById($entityName$, $id$)", "根据主键查询数据，返回: JSONObject(实体)",
                new Variable("entityName", String.class),
                new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.getByCondition(列字段, 实体名, 条件表达式)", "entity.getByCondition($columns$, $entityName$, $condition$)", "根据条件表达式查询数据，返回: JSONArray(结果集)",
                new Variable("columns", String.class),
                new Variable("entityName", String.class),
                new Variable("condition", Condition.class)));
        coreTemplates.add(new Template("entity.getByCondition(实体名, 条件表达式)", "entity.getByCondition($entityName$, $condition$)", "根据条件表达式查询数据，返回: JSONArray(结果集)",
                new Variable("entityName", String.class),
                new Variable("condition", Condition.class)));
        coreTemplates.add(new Template("entity.delete(实体名, 主键值)", "entity.delete($entityName$, $id$)", "删除单个实体，返回: Integer(影响行数)",
                new Variable("entityName", String.class),
                new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.deleteAllByIds(实体名, 主键值集合)", "entity.deleteAllByIds($entityName$, $ids$)", "批量删除实体，返回: Integer(影响行数)",
                new Variable("entityName", String.class),
                new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.findAllByIds(列字段, 实体名, 主键值集合)", "entity.findAllByIds($columns$, $entityName$, $ids$)", "根据主键集合查询所有数据，返回: JSONArray(结果集)",
                new Variable("columns", String.class),
                new Variable("entityName", String.class),
                new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.findAllByIds(实体名, 主键值集合)", "entity.findAllByIds($entityName$, $ids$)", "根据主键集合查询所有数据，返回: JSONArray(结果集)",
                new Variable("entityName", String.class),
                new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.getCount(实体名)", "entity.getCount($entityName$)", "查询实体的总数量，返回: Integer(总数)",
                new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.findAll(列字段, 实体名)", "entity.findAll($columns$, $entityName$)", "查询实体的所有数据，返回: JSONArray(结果集)",
                new Variable("columns", String.class),
                new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.findAll(实体名)", "entity.findAll($entityName$)", "查询实体的所有数据，返回: JSONArray(结果集)",
                new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.saveByKey(实体名, 数据实体, 指定键集合, 是否覆盖已有数据)", "entity.saveByKey($entityName$, $row$, $keyArray$, $isCover$)", "根据指定键保存实体，返回：JSONObject(实体)",
                new Variable("entityName", String.class),
                new Variable("row", JSONObject.class),
                new Variable("keyArray", JSONArray.class),
                new Variable("isCover", Boolean.class)));
        coreTemplates.add(new Template("entity.saveByKey(实体名, 数据实体, 指定键集合)", "entity.saveByKey($entityName$, $row$, $keyArray$)", "根据指定键保存实体(覆盖已有数据)，返回：JSONObject(实体)",
                new Variable("entityName", String.class),
                new Variable("row", JSONObject.class),
                new Variable("keyArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.partialSave(实体名, 数据实体)", "entity.partialSave($entityName$, $row$)", "实体保存，返回：JSONObject(实体)",
                new Variable("entityName", String.class),
                new Variable("row", JSONObject.class)));
        coreTemplates.add(new Template("entity.partialSave(实体名, 数据实体集合)", "entity.partialSave($entityName$, $rowArray$)", "实体批量保存，返回：JSONArray(实体集合)",
                new Variable("entityName", String.class),
                new Variable("rowArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.sqlserverBulkInsert(实体名, 数据实体集合)", "entity.sqlserverBulkInsert($entityName$, $rowArray$)", "Sqlserver大数据批量插入，返回：void",
                new Variable("entityName", String.class),
                new Variable("rowArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteDelete(服务名, 实体名, 主键值)", "entity.remoteDelete($serviceName$, $entityName$, $id$)", "远程调用删除实体，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.remoteDeleteAllByIds(服务名, 实体名, 主键值集合)", "entity.remoteDeleteAllByIds($serviceName$, $entityName$, $ids$)", "远程调用批量删除实体，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteFindAllByIds(服务名, 列字段, 实体名, 主键值集合)", "entity.remoteFindAllByIds($serviceName$, $columns$, $entityName$, $ids$)", "远程调用根据主键集合查询所有数据，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("columns", String.class),
                new Variable("entityName", String.class),
                new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteFindAllByIds(服务名, 实体名, 主键值集合)", "entity.remoteFindAllByIds($serviceName$, $columns$, $entityName$, $ids$)", "远程调用根据主键集合查询所有数据，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteGetCount(服务名, 实体名)", "entity.remoteGetCount($serviceName$, $entityName$)", "远程调用查询实体的总数量，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.remoteFindAll(服务名, 列字段, 实体名)", "entity.remoteFindAll($serviceName$, $columns$, $entityName$)", "远程调用查询所有数据，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("columns", String.class),
                new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.remoteFindAll(服务名, 实体名)", "entity.remoteFindAll($serviceName$, $entityName$)", "远程调用查询所有数据，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.remoteGetById(服务名, 列字段, 实体名, 主键值)", "entity.remoteGetById($serviceName$, $columns$, $entityName$, $id$)", "远程调用根据主键查询数据，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("columns", String.class),
                new Variable("entityName", String.class),
                new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.remoteGetById(服务名, 实体名, 主键值)", "entity.remoteGetById($serviceName$, $entityName$, $id$)", "远程调用根据主键查询数据，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.remoteSaveByKey(服务名, 实体名, 数据实体, 指定键集合, 是否覆盖已有数据)", "entity.remoteSaveByKey($serviceName$, $entityName$, $row$, $keyArray$, $isCover$)", "远程根据指定键保存实体，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("row", JSONObject.class),
                new Variable("keyArray", JSONArray.class),
                new Variable("isCover", Boolean.class)));
        coreTemplates.add(new Template("entity.remoteSaveByKey(服务名, 实体名, 数据实体, 指定键集合)", "entity.remoteGetById($serviceName$, $entityName$, $row$, $keyArray$)", "远程根据指定键保存实体，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("row", JSONObject.class),
                new Variable("keyArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.remotePartialSave(服务名, 实体名, 数据实体)", "entity.remotePartialSave($serviceName$, $entityName$, $row$)", "远程调用实体保存，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("row", JSONObject.class)));
        coreTemplates.add(new Template("entity.remotePartialSave(服务名, 实体名, 数据实体集合)", "entity.remotePartialSave($serviceName$, $entityName$, $rowArray$)", "远程调用实体批量保存，返回: JSONObject(执行结果)",
                new Variable("serviceName", String.class),
                new Variable("entityName", String.class),
                new Variable("rowArray", JSONArray.class)));
        //core-redis
        coreTemplates.add(new Template("redis.set(键, 值)", "redis.set($key$, $value$)", "redis保存数据，返回: Object(存入的数据对象)",
                new Variable("key", String.class),
                new Variable("value", Object.class)));
        coreTemplates.add(new Template("redis.set(键, 值, 过期时间(秒))", "redis.set($key$, $value$, $timeoutSec$)", "redis保存数据，返回: Object(存入的数据对象)",
                new Variable("key", String.class),
                new Variable("value", Object.class),
                new Variable("timeoutSec", Object.class)));
        coreTemplates.add(new Template("redis.get(键)", "redis.get($key$)", "redis根据key获取数据，返回: Object(存入的数据对象)",
                new Variable("key", String.class)));
        coreTemplates.add(new Template("redis.hasKey(键)", "redis.hasKey($key$)", "redis判断key是否存在，返回: Boolean",
                new Variable("key", String.class)));
        coreTemplates.add(new Template("redis.delete(键)", "redis.delete($key$)", "redis根据key删除数据，返回: void",
                new Variable("key", String.class)));
        coreTemplates.add(new Template("redis.deleteList(键集合)", "redis.deleteList($keys$)", "redis根据key集合删除数据，返回: void",
                new Variable("keys", JSONArray.class)));
        //core-liuLiConfig
        coreTemplates.add(new Template("liuLiConfig.get(配置名称)", "liuLiConfig.get($configName$)", "获取配置文件，返回: JSONObject",
                new Variable("configName", String.class)));
        TemplateGroup core = new TemplateGroup("核心", "core", coreTemplates);
        //plugins
        List<Template> pluginsTemplates = new ArrayList<>();
        //plugins-core
        pluginsTemplates.add(new Template("commonTools.getInstance(全限定类名, 构造参数集合)", "commonTools.getInstance($className$, $constructorParam$)", "反射获取对象实例，返回: Object(对象实例)",
                new Variable("className", String.class),
                new Variable("constructorParam", JSONArray.class)));
        pluginsTemplates.add(new Template("commonTools.getInstance(全限定类名)", "commonTools.getInstance($className$)", "反射获取对象实例，返回: Object(对象实例)",
                new Variable("className", String.class)));
        pluginsTemplates.add(new Template("commonTools.getUUID(是否带分隔字符)", "commonTools.getUUID($isSimple$)", "生成一个UUID，返回: String(UUID字符串)",
                new Variable("isSimple", Boolean.class)));
        pluginsTemplates.add(new Template("commonTools.getUUID()", "commonTools.getUUID()", "生成一个带分隔字符的UUID，返回: String(UUID字符串)"));
        pluginsTemplates.add(new Template("commonTools.md5(内容)", "commonTools.md5($value$)", "md5编码，返回: String(MD5字符串)",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.md5(内容, 盐值)", "commonTools.md5($value$, $salt$)", "md5编码，返回: String(MD5字符串)",
                new Variable("value", String.class),
                new Variable("salt", String.class)));
        pluginsTemplates.add(new Template("commonTools.getRandomNumber(最小值(包含), 最大值(包含))", "commonTools.getRandomNumber($min$, $max$)", "获取指定范围的伪随机数，返回: Integer(随机数)",
                new Variable("min", Integer.class),
                new Variable("max", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.isNumeric(内容)", "commonTools.isNumeric($value$)", "判断内容是否为数字，返回: Boolean",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.add(被加数, 加数)", "commonTools.add($num1$, $num2$)", "精确加法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.add(被加数, 加数, 精度)", "commonTools.add($num1$, $num2$, $scale$)", "精确加法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class),
                new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.sub(被减数, 减数)", "commonTools.sub($num1$, $num2$)", "精确减法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.sub(被加数, 加数, 精度)", "commonTools.sub($num1$, $num2$, $scale$)", "精确减法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class),
                new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.mul(被乘数, 乘数)", "commonTools.mul($num1$, $num2$)", "精确乘法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.mul(被乘数, 乘数, 精度)", "commonTools.mul($num1$, $num2$, $scale$)", "精确乘法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class),
                new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.div(被除数, 除数)", "commonTools.div($num1$, $num2$)", "精确除法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.div(被除数, 除数, 精度)", "commonTools.div($num1$, $num2$, $scale$)", "精确除法运算，返回: BigDecimal",
                new Variable("num1", Object.class),
                new Variable("num2", Object.class),
                new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.split(内容, 分割符)", "commonTools.split($content$, $separator$)", "字符串分割，返回: JSONArray",
                new Variable("content", String.class),
                new Variable("separator", String.class)));
        pluginsTemplates.add(new Template("commonTools.url2json(URL参数)", "commonTools.url2json($urlParams$)", "Url参数转Json，返回: JSONObject",
                new Variable("urlParams", String.class)));
        pluginsTemplates.add(new Template("commonTools.isContains(字符串, 搜索值)", "commonTools.isContains($str$, $searchStr$)", "指定字符串是否在字符串中出现过，返回: Boolean",
                new Variable("str", String.class),
                new Variable("searchStr", String.class)));
        pluginsTemplates.add(new Template("commonTools.union(JSON集合)", "commonTools.union($array$)", "合并JSONArray里的所有字符串，形式为：'a','b'，返回: String",
                new Variable("array", JSONArray.class)));
        pluginsTemplates.add(new Template("commonTools.union(JSON集合, key)", "commonTools.union($array$, $key$)", "合并JSONArray里JSONObject指定key的所有字符串，形式为：'a','b'，返回: String",
                new Variable("array", JSONArray.class),
                new Variable("key", String.class)));
        pluginsTemplates.add(new Template("commonTools.formatStrByParams(字符串内容, 参数JSON)", "commonTools.formatStrByParams($content$, $params$)", "根据参数字典格式化字符串，返回: String",
                new Variable("content", String.class),
                new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("commonTools.formatNumber(数字值)", "commonTools.formatNumber($number$)", "将数字按标准格式转换，返回: String",
                new Variable("number", Object.class)));
        pluginsTemplates.add(new Template("commonTools.stringToInt(字符串)", "commonTools.stringToInt($value$)", "字符串转整数，返回: Integer",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.stringToDouble(字符串)", "commonTools.stringToDouble($value$)", "字符串转Double，返回: Double",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.stringToBigDecimal(字符串)", "commonTools.stringToBigDecimal($value$)", "字符串转BigDecimal，返回: BigDecimal",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.bigDecimalToString(BigDecimal对象)", "commonTools.bigDecimalToString($value$)", "BigDecimal转String，返回: String",
                new Variable("value", BigDecimal.class)));
        pluginsTemplates.add(new Template("commonTools.byteArrayToString(字节数组)", "commonTools.byteArrayToString($value$)", "byte数组转字符串，返回: String",
                new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.byteArrayToCharsetString(字节数组, 编码格式)", "commonTools.byteArrayToCharsetString($value$, $charset$)", "byte数组转字符串，返回: String",
                new Variable("value", byte[].class),
                new Variable("charset", String.class)));
        pluginsTemplates.add(new Template("commonTools.base64Encode(字节数组)", "commonTools.base64Encode($value$)", "对byte数组Base64编码，返回: String",
                new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.base64Decode(字节数组)", "commonTools.base64Decode($value$)", "对byte数组Base64解码，返回: String",
                new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.byteToHexStr(字节数组)", "commonTools.byteToHexStr($value$)", "byte数组转16进制字符串，返回: String",
                new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.hexStrToByte(16进制字符串)", "commonTools.hexStrToByte($value$)", "16进制字符串转byte数组，返回: byte[]",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.strToBytes(字符串)", "commonTools.strToBytes($value$)", "字符串转byte数组，返回: byte[]",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.bytesToStr(字节数组)", "commonTools.bytesToStr($value$)", "byte数组转字符串，返回: String",
                new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.stringToCharset(字符串, 原编码格式, 新编码格式)", "commonTools.stringToCharset($value$, $oldCharset$, $newCharset$)", "根据指定编码格式转换字符串，返回: String",
                new Variable("value", byte[].class),
                new Variable("oldCharset", String.class),
                new Variable("newCharset", String.class)));
        pluginsTemplates.add(new Template("commonTools.ceil(数字值)", "commonTools.ceil($value$)", "向上取整，返回: Integer",
                new Variable("value", Object.class)));
        pluginsTemplates.add(new Template("commonTools.ceil(数字值, 精度)", "commonTools.ceil($value$, $scale$)", "按精度向上转换，返回: Double",
                new Variable("value", Object.class),
                new Variable("scale", Object.class)));
        pluginsTemplates.add(new Template("commonTools.floor(数字值)", "commonTools.floor($value$)", "向下取整，返回: Integer",
                new Variable("value", Object.class)));
        pluginsTemplates.add(new Template("commonTools.floor(数字值, 精度)", "commonTools.floor($value$, $scale$)", "按精度向下转换，返回: Double",
                new Variable("value", Object.class),
                new Variable("scale", Object.class)));
        pluginsTemplates.add(new Template("commonTools.round(数字值)", "commonTools.round($value$)", "四舍五入取整，返回: Integer",
                new Variable("value", Object.class)));
        pluginsTemplates.add(new Template("commonTools.round(数字值, 精度)", "commonTools.round($value$, $scale$)", "按精度四舍五入，返回: Double",
                new Variable("value", Object.class),
                new Variable("scale", Object.class)));
        pluginsTemplates.add(new Template("commonTools.replaceAll(待替换字符串)", "commonTools.replaceAll($value$)", "去除字符串所有空格，返回: String",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.splitString(待分割内容, 分割符)", "commonTools.splitString($value$, $flag$)", "字符串分割成JSON集合，返回: JSONArray",
                new Variable("value", String.class),
                new Variable("flag", String.class)));
        //plugins-date
        pluginsTemplates.add(new Template("dateTools.getNow2()", "dateTools.getNow2()", "获取当前日期字符串(格式:yyyy-MM-dd HH:mm:ss)，返回: String"));
        pluginsTemplates.add(new Template("dateTools.getCurrentTimeMillis()", "dateTools.getCurrentTimeMillis()", "获取当前时间戳，返回: Long"));
        pluginsTemplates.add(new Template("dateTools.getNow(目标日期格式)", "dateTools.getNow($format$)", "获取当前日期字符串，返回: String",
                new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getNowYear()", "dateTools.getNowYear()", "返回当前日期的年份，返回: String"));
        pluginsTemplates.add(new Template("dateTools.getNowMonth()", "dateTools.getNowMonth()", "返回当前日期的月份，返回: String"));
        pluginsTemplates.add(new Template("dateTools.getNowMonthAsInt()", "dateTools.getNowMonthAsInt()", "返回当前日期的月份整数，返回: Integer"));
        pluginsTemplates.add(new Template("dateTools.getNowDay()", "dateTools.getNowDay()", "返回当前日期的天，返回: String"));
        pluginsTemplates.add(new Template("dateTools.getNowDayOfWeek()", "dateTools.getNowDayOfWeek()", "返回当前日期的星期，返回: String"));
        pluginsTemplates.add(new Template("dateTools.getMonth(日期串)", "dateTools.getMonth($value$)", "获取指定日期的月份，返回: Integer",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDate(日期串)", "dateTools.getDate($value$)", "获取指定日期的天，返回: Integer",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.getYearMonth(日期串)", "dateTools.getYearMonth($value$)", "获取指定日期的年月(格式:yyyyMM)，返回: String",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.format(日期串, 目标日期格式)", "dateTools.format($value$, $format$)", "格式化日期字符串，返回: String",
                new Variable("value", String.class),
                new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.formatDateTime(日期字符串)", "dateTools.formatDateTime($value$)", "将日期字符串转换为标准日期格式，返回: String",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.formatDateTime(日期串, 该字符串的日期格式)", "dateTools.formatDateTime($value$, $format$)", "将指定日期格式字符串转换为标准日期格式，返回: String",
                new Variable("value", String.class),
                new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.formatDateTime(日期串, 原日期格式, 目标日期格式)", "dateTools.formatDateTime($value$, $format$, $newFormat$)", "格式化日期字符串，返回: String",
                new Variable("value", String.class),
                new Variable("format", String.class),
                new Variable("newFormat", String.class)));
        pluginsTemplates.add(new Template("dateTools.compareDate(日期串1, 日期串2)", "dateTools.compareDate($value$, $value2$)", "比较两个日期的大小，返回: Boolean(a>=b)",
                new Variable("value", String.class),
                new Variable("value2", String.class)));
        pluginsTemplates.add(new Template("dateTools.compareFormatDate(日期串1, 日期串2, 日期格式)", "dateTools.compareFormatDate($value$, $value2$, $format$)", "比较两个日期的大小，返回: Boolean(a>=b)",
                new Variable("value", String.class),
                new Variable("value2", String.class),
                new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getStartDate(日期串, 操作类型, 目标日期格式)", "dateTools.getStartDate($value$, $type$, $format$)", "获取指定日期的开始日期，返回: String",
                new Variable("value", String.class),
                new Variable("type", String.class),
                new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getStartDate(日期串, 操作类型)", "dateTools.getStartDate($value$, $type$)", "获取指定日期的开始日期，返回: String",
                new Variable("value", String.class),
                new Variable("type", String.class)));
        pluginsTemplates.add(new Template("dateTools.getEndDate(日期串, 操作类型, 目标日期格式)", "dateTools.getEndDate($value$, $type$, $format$)", "获取指定日期的结束日期，返回: String",
                new Variable("value", String.class),
                new Variable("type", String.class),
                new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getEndDate(日期串, 操作类型)", "dateTools.getEndDate($value$, $type$)", "获取指定日期的结束日期，返回: String",
                new Variable("value", String.class),
                new Variable("type", String.class)));
        pluginsTemplates.add(new Template("dateTools.getStairStartDate(开始日期串, 阶梯周期, 抄表日期串)", "dateTools.getStairStartDate($start$, $cycle$, $handDate$)", "获取阶梯开始日期，返回: String",
                new Variable("start", String.class),
                new Variable("cycle", String.class),
                new Variable("handDate", String.class)));
        pluginsTemplates.add(new Template("dateTools.isLastYear(日期串)", "dateTools.isLastYear($value$)", "比较指定日期和当前日期的年份，返回: Boolean(a>=b)",
                new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDiffDate(操作类型, 差值, 目标日期格式)", "dateTools.getDiffDate($type$, $param$, $format$)", "根据操作类型获取当前日期的前后日期，返回: String",
                new Variable("type", String.class),
                new Variable("param", String.class),
                new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDelayDate(日期串, 操作类型, 差值)", "dateTools.getDelayDate($date$, $type$, $param$)", "根据操作类型获取指定日期的前后日期，返回: String",
                new Variable("date", String.class),
                new Variable("type", String.class),
                new Variable("param", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDateBetween(日期串1, 日期串2)", "dateTools.getDateBetween($date1$, $date2$)", "获取两个时间的相差毫秒数，绝对值，返回: String",
                new Variable("date1", String.class),
                new Variable("date2", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDateDayBetween(日期串1, 日期串2, 是否忽略时分秒)", "dateTools.getDateDayBetween($date1$, $date2$, $isReset$)", "获取两个时间的天数相差间隔，绝对值，返回: String",
                new Variable("date1", String.class),
                new Variable("date2", String.class),
                new Variable("isReset", Boolean.class)));
        //plugins-http
        pluginsTemplates.add(new Template("restTools.post(请求路径, 请求体, 请求头)", "restTools.post($url$, $value$, $header$)", "POST请求，返回: String",
                new Variable("url", String.class),
                new Variable("value", String.class),
                new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.post(请求路径, 请求体)", "restTools.post($url$, $value$)", "POST请求，返回: String",
                new Variable("url", String.class),
                new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.postByFormData(请求路径, 请求体, 请求头)", "restTools.postByFormData($url$, $value$, $header$)", "POST请求，form-data格式，返回: String",
                new Variable("url", String.class),
                new Variable("value", String.class),
                new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.postByFormData(请求路径, 请求体)", "restTools.postByFormData($url$, $value$)", "POST请求，form-data格式，返回: String",
                new Variable("url", String.class),
                new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.get(请求路径, 请求头)", "restTools.get($url$, $header$)", "GET请求，返回: String",
                new Variable("url", String.class),
                new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.get(请求路径)", "restTools.get($url$)", "GET请求，返回: String",
                new Variable("url", String.class)));
        pluginsTemplates.add(new Template("restTools.put(请求路径, 请求体, 请求头)", "restTools.put($url$, $value$, $header$)", "PUT请求，返回: String",
                new Variable("url", String.class),
                new Variable("value", String.class),
                new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.put(请求路径, 请求体)", "restTools.put($url$, $value$)", "PUT请求，返回: String",
                new Variable("url", String.class),
                new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.delete(请求路径, 请求体, 请求头)", "restTools.delete($url$, $value$, $header$)", "DELETE请求，返回: String",
                new Variable("url", String.class),
                new Variable("value", String.class),
                new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.delete(请求路径, 请求体)", "restTools.delete($url$, $value$)", "DELETE请求，返回: String",
                new Variable("url", String.class),
                new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.formatURL(请求路径, 请求体)", "restTools.formatURL($url$, $params$)", "URL拼接请求参数，返回: String",
                new Variable("url", String.class),
                new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.formatAndEncodeURL(请求路径, 请求体)", "restTools.formatAndEncodeURL($url$, $params$)", "URL拼接URLEncode编码的请求参数，返回: String",
                new Variable("url", String.class),
                new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("restAsyncTools.post(请求路径, 请求体)", "restAsyncTools.post($url$, $value$)", "POST异步请求，返回: void",
                new Variable("url", String.class),
                new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restAsyncTools.get(请求路径)", "restAsyncTools.get($url$)", "GET异步请求，返回: void",
                new Variable("url", String.class)));
        pluginsTemplates.add(new Template("restAsyncTools.put(请求路径, 请求体)", "restAsyncTools.put($url$, $value$)", "PUT异步请求，返回: void",
                new Variable("url", String.class),
                new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restAsyncTools.delete(请求路径, 请求体)", "restAsyncTools.delete($url$, $value$)", "DELETE异步请求，返回: void",
                new Variable("url", String.class),
                new Variable("value", JSONObject.class)));
        //plugins-io
        pluginsTemplates.add(new Template("ioTools.hasResource(文件路径)", "ioTools.hasResource($path$)", "判断文件是否存在，返回: Boolean",
                new Variable("path", String.class)));
        pluginsTemplates.add(new Template("ioTools.readText(文件路径)", "ioTools.readText($path$)", "获取文本内容，返回: String",
                new Variable("path", String.class)));
        //plugins-json
        pluginsTemplates.add(new Template("jsonTools.addJSON(被追加的JSON对象, 追加的JSON对象)", "jsonTools.addJSON($a$, $b$)", "给JSON对象追加目标JSON对象的所有成员，返回: JSONObject",
                new Variable("a", JSONObject.class),
                new Variable("b", JSONObject.class)));
        pluginsTemplates.add(new Template("jsonTools.convertToJson(JSON字符串)", "jsonTools.convertToJson($str$)", "字符串转换为JSON对象，返回: JSONObject",
                new Variable("str", String.class)));
        pluginsTemplates.add(new Template("jsonTools.parseArray(JSON字符串)", "jsonTools.parseArray($str$)", "字符串转换为JSON集合，返回: JSONArray",
                new Variable("str", String.class)));
        pluginsTemplates.add(new Template("jsonTools.getArray()", "jsonTools.getArray()", "获取一个JSON集合对象，返回: JSONArray"));
        pluginsTemplates.add(new Template("jsonTools.getArray(长度)", "jsonTools.parseArray($num$)", "获取一个指定长度的JSON集合对象，返回: JSONArray",
                new Variable("num", Object.class)));
        pluginsTemplates.add(new Template("jsonTools.replaceJSON(被替换的JSON对象, 替换的JSON对象)", "jsonTools.replaceJSON($a$, $b$)", "JSON键值对替换（保留原JSON中的键值对），返回: JSONObject",
                new Variable("a", JSONObject.class),
                new Variable("b", JSONObject.class)));
        pluginsTemplates.add(new Template("jsonTools.readJsonFile(文件路径)", "jsonTools.readJsonFile($path$)", "读取JSON文件，返回JSON对象，返回: JSONObject",
                new Variable("path", String.class)));
        pluginsTemplates.add(new Template("jsonTools.readJsonArrayFile(文件路径)", "jsonTools.readJsonArrayFile($path$)", "读取JSON文件，返回JSON集合对象，返回: JSONArray",
                new Variable("path", String.class)));
        pluginsTemplates.add(new Template("jsonTools.formatJsonByParams(JSON对象, 参数字典)", "jsonTools.formatJsonByParams($object$, $params$)", "根据参数字典格式化Json，返回: JSONObject",
                new Variable("object", JSONObject.class),
                new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("jsonTools.formatJsonArrayByParams(JSON对象, 参数字典)", "jsonTools.formatJsonArrayByParams($object$, $params$)", "根据参数字典格式化JSON集合，返回: JSONArray",
                new Variable("object", JSONObject.class),
                new Variable("params", JSONObject.class)));
        TemplateGroup plugins = new TemplateGroup("af-common-plugins", "af-common-plugins", pluginsTemplates);
        //expression
        List<Template> expressionTemplates = new ArrayList<>();
        expressionTemplates.add(new Template("for", """
                $object$.each(
                    $body$
                )
                """, "For循环", new Variable("object"), new Variable("body")));
        expressionTemplates.add(new Template("if", """
                $expression$ :(
                     $body$
                ),null
                """, "if判断", new Variable("expression"), new Variable("body")));
        expressionTemplates.add(new Template("if...else", """
                $expression$ :(
                    $body$
                ),(
                    $body2$
                )
                """, "if...else判断", new Variable("expression"), new Variable("body"), new Variable("body2")));
        expressionTemplates.add(new Template("if...else if...else", """
                $expression$ :(
                    $body$
                ),
                $expression2$ :(
                    $body2$
                ),
                (
                    $body3$
                )
                """, "多重if判断", new Variable("expression"), new Variable("body"), new Variable("expression2"), new Variable("body2"), new Variable("body3")));
        expressionTemplates.add(new Template("json", """
                $jsonName$ = {
                    $body$
                }
                """, "创建JSON对象", new Variable("jsonName"), new Variable("body")));
        expressionTemplates.add(new Template("jsonArray", """
                $jsonArrayName$ = [
                    $body$
                ]
                """, "创建JSONArray对象", new Variable("jsonArrayName"), new Variable("body")));
        TemplateGroup expression = new TemplateGroup("af-common-expression", "af-common-expression", expressionTemplates);
        TEMPLATE_GROUP_LIST = new ArrayList<>();
        TEMPLATE_GROUP_LIST.add(core);
        TEMPLATE_GROUP_LIST.add(plugins);
        TEMPLATE_GROUP_LIST.add(expression);
    }

    public static void createXml() throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("templateSet").addAttribute("group", "Logic");
        TEMPLATE_GROUP_LIST.forEach(group -> {
            List<Template> templates = group.getTemplateList();
            templates.forEach(template -> {
                Element element = root.addElement("template");
                element.addAttribute("name", template.getName());
                element.addAttribute("value", template.getValue());
                element.addAttribute("description", template.getDescription());
                element.addAttribute("toReformat", "true");
                element.addAttribute("toShortenFQNames", "true");
                Variable[] variables = template.getVariableList();
                if (variables != null) {
                    for (Variable variable : variables) {
                        Element variableElement = element.addElement("variable");
                        variableElement.addAttribute("name", variable.getName());
                        variableElement.addAttribute("expression", variable.getExpression());
                        variableElement.addAttribute("defaultValue", "");
                        variableElement.addAttribute("alwaysStopAt", "true");
                    }
                }
                Element context = element.addElement("context");
                Element option = context.addElement("option");
                option.addAttribute("name", "OTHER");
                option.addAttribute("value", "true");
            });
        });
        OutputFormat of = OutputFormat.createPrettyPrint();
        of.setEncoding(StandardCharsets.UTF_8.name());
        File file = new File("Logic.xml");
        if (file.exists()) {
            file.delete();
        }
        XMLWriter writer = new XMLWriter(new FileOutputStream(file), of);
        writer.write(document);
        writer.close();
    }

    static void main(String[] args) throws IOException {
        createXml();
    }
}
