/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.calculate;

import com.af.v4.system.common.plugins.calculate.ISettlementInterface;
import com.af.v4.system.common.plugins.core.PriceFormatTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.json.JSONArray;
import org.json.JSONObject;

public class MixedpriceSettlement
implements ISettlementInterface {
    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        return this.calcChargeInternal(chargeInfo, gas, false);
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        return this.calcAmountInternal(chargeInfo, fee, false);
    }

    @Override
    public JSONObject calcCharge2(JSONArray chargeInfo, BigDecimal gas) {
        return this.calcChargeInternal(chargeInfo, gas, true);
    }

    @Override
    public JSONObject calcAmount2(JSONArray chargeInfo, BigDecimal fee) {
        return this.calcAmountInternal(chargeInfo, fee, true);
    }

    private JSONObject calcChargeInternal(JSONArray chargeInfo, BigDecimal gas, boolean useTwoDecimal) {
        BigDecimal hybridprice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1")));
        BigDecimal hybridprice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice2")));
        BigDecimal hybridprice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1rate")));
        BigDecimal gas1 = gas.multiply(hybridprice1rate);
        BigDecimal gas2 = new BigDecimal("1").subtract(hybridprice1rate).multiply(gas);
        BigDecimal chargenum1 = gas1.multiply(hybridprice1);
        BigDecimal chargenum2 = gas2.multiply(hybridprice2);
        if (useTwoDecimal) {
            PriceFormatTools.formatNumberBaseTwoDecimal(chargenum1);
            PriceFormatTools.formatNumberBaseTwoDecimal(chargenum2);
        } else {
            PriceFormatTools.formatNumberBase(chargenum1);
            PriceFormatTools.formatNumberBase(chargenum2);
        }
        BigDecimal chargenum = chargenum1.add(chargenum2);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", (Object)"\u6df7\u54081");
        json.put("f_price", (Object)hybridprice1);
        json.put("f_gas", (Object)gas1);
        json.put("f_money", (Object)chargenum1);
        array.put((Object)json);
        JSONObject json2 = new JSONObject();
        json2.put("f_price_name", (Object)"\u6df7\u54082");
        json2.put("f_price", (Object)hybridprice2);
        json2.put("f_gas", (Object)gas2);
        json2.put("f_money", (Object)chargenum2);
        array.put((Object)json2);
        JSONObject ret = new JSONObject();
        ret.put("chargeprice", (Object)array);
        ret.put("chargenum", (Object)chargenum);
        if (useTwoDecimal) {
            PriceFormatTools.formatNumberTwoDecimal(ret);
        } else {
            PriceFormatTools.formatNumber(ret);
        }
        return ret;
    }

    private JSONObject calcAmountInternal(JSONArray chargeInfo, BigDecimal fee, boolean useTwoDecimal) {
        BigDecimal hybridprice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1")));
        BigDecimal hybridprice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice2")));
        BigDecimal hybridprice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1rate")));
        BigDecimal amount = fee.divide(hybridprice1rate.multiply(hybridprice1).add(new BigDecimal("1").subtract(hybridprice1rate).multiply(hybridprice2)), 0, RoundingMode.DOWN);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", (Object)"\u6df7\u54081");
        json.put("f_price", (Object)hybridprice1);
        json.put("f_gas", (Object)amount);
        json.put("f_money", (Object)fee);
        array.put((Object)json);
        JSONObject json2 = new JSONObject();
        json2.put("f_price_name", (Object)"\u6df7\u54082");
        json2.put("f_price", (Object)hybridprice2);
        json2.put("f_gas", (Object)amount);
        json2.put("f_money", (Object)fee);
        array.put((Object)json2);
        JSONObject ret = new JSONObject();
        ret.put("chargeprice", (Object)array);
        ret.put("gas", (Object)amount);
        if (useTwoDecimal) {
            PriceFormatTools.formatNumberTwoDecimal(ret, "f_price");
        } else {
            PriceFormatTools.formatNumber(ret, "f_price");
        }
        return ret;
    }
}

