package com.af.v4.system.common.plugins.calculate;

import com.af.v4.system.common.plugins.core.PriceFormatTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * caption
 * 单价计算方法。
 * 费用 = 单价* 数量
 *
 * @author Lyf
 */
public class UnitpriceSettlement implements ISettlementInterface {

    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        return calcChargeInternal(chargeInfo, gas, false);
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        return calcAmountInternal(chargeInfo, fee, false);
    }

    @Override
    public JSONObject calcCharge2(JSONArray chargeInfo, BigDecimal gas) {
        return calcChargeInternal(chargeInfo, gas, true);
    }

    @Override
    public JSONObject calcAmount2(JSONArray chargeInfo, BigDecimal fee) {
        return calcAmountInternal(chargeInfo, fee, true);
    }

    // 内部通用方法，便于复用
    private JSONObject calcChargeInternal(JSONArray chargeInfo, BigDecimal gas, boolean useTwoDecimal) {
        // 单价
        BigDecimal unitprice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitprice")));
        //费用 = 单价* 气量
        BigDecimal chargenum = unitprice.multiply(gas);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", "固定气价");
        json.put("f_price", unitprice);
        json.put("f_gas", gas);
        json.put("f_money", chargenum);
        array.put(json);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("chargenum", chargenum);
        ret.put("gas", gas);
        ret.put("money", chargenum);

        // 根据小数位数选择格式化方式
        if (useTwoDecimal) {
            PriceFormatTools.formatNumberTwoDecimal(ret, "f_price");
        } else {
            PriceFormatTools.formatNumber(ret, "f_price");
        }
        return ret;
    }

    // 内部通用方法，便于复用
    private JSONObject calcAmountInternal(JSONArray chargeInfo, BigDecimal fee, boolean useTwoDecimal) {
        //单价
        BigDecimal unitprice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitprice")));
        BigDecimal amount = fee.divide(unitprice, 4, RoundingMode.DOWN);

        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", "固定气价");
        json.put("f_price", unitprice);
        json.put("f_gas", amount);
        json.put("f_money", fee);
        array.put(json);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("gas", amount);
        ret.put("money", fee);
        ret.put("chargenum", fee);

        // 根据小数位数选择格式化方式
        if (useTwoDecimal) {
            PriceFormatTools.formatNumberTwoDecimal(ret, "f_price");
        } else {
            PriceFormatTools.formatNumber(ret, "f_price");
        }
        return ret;
    }
}
