/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.json.JSONArray;

public class SqlTools {
    private static final String PLACEHOLDER = "[ROW]";
    private static final String FORMAT_YEAR = "yyyy";
    private static final String FORMAT_MONTH = "yyyyMM";
    private static final String FORMAT_DAY = "yyyyMMdd";

    private static void validateArrayParam(Object arr) {
        if (arr == null) {
            throw new IllegalArgumentException("\u53c2\u6570 arr \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arr instanceof JSONArray && ((JSONArray)arr).isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570 arr \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arr instanceof List && ((List)arr).isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570 arr \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void validateSqlParam(String sql) {
        if (sql == null || sql.trim().isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570 sql \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void validateDateFormat(String format) {
        if (format == null || !format.equals(FORMAT_YEAR) && !format.equals(FORMAT_MONTH) && !format.equals(FORMAT_DAY)) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f: " + format + ", \u4ec5\u652f\u6301 yyyy/yyyyMM/yyyyMMdd");
        }
    }

    public static String renderUnionSql(JSONArray arr, String sql) {
        return SqlTools.renderUnionSql(arr, sql, true);
    }

    public static String renderUnionSql(JSONArray arr, String sql, boolean wrapOuter) {
        return SqlTools.renderUnionSqlInternal(arr, sql, wrapOuter);
    }

    private static String renderUnionSqlInternal(JSONArray arr, String sql, boolean wrapOuter) {
        SqlTools.validateArrayParam(arr);
        SqlTools.validateSqlParam(sql);
        if (!sql.contains(PLACEHOLDER)) {
            return sql;
        }
        StringBuilder result = new StringBuilder();
        if (wrapOuter) {
            result.append("select * from (\n");
        }
        for (int i = 0; i < arr.length(); ++i) {
            Object value = arr.get(i);
            String subQuery = sql.replace(PLACEHOLDER, String.valueOf(value));
            result.append(subQuery);
            if (i >= arr.length() - 1) continue;
            result.append("\nunion all\n");
        }
        if (wrapOuter) {
            result.append("\n) t");
        }
        return result.toString();
    }

    public static String renderUnionSql(List<?> arr, String sql) {
        return SqlTools.renderUnionSql(arr, sql, true);
    }

    public static String renderUnionSql(List<?> arr, String sql, boolean wrapOuter) {
        SqlTools.validateArrayParam(arr);
        JSONArray jsonArray = new JSONArray(arr);
        return SqlTools.renderUnionSqlInternal(jsonArray, sql, wrapOuter);
    }

    public static String renderUnionSqlForDate(JSONArray arr, String sql, String format) {
        return SqlTools.renderUnionSqlForDate(arr, sql, format, true);
    }

    public static String renderUnionSqlForDate(JSONArray arr, String sql, String format, boolean wrapOuter) {
        return SqlTools.renderUnionSqlForDateInternal(arr, sql, format, wrapOuter);
    }

    private static String renderUnionSqlForDateInternal(JSONArray arr, String sql, String format, boolean wrapOuter) {
        SqlTools.validateArrayParam(arr);
        SqlTools.validateSqlParam(sql);
        if (!sql.contains(PLACEHOLDER)) {
            return sql;
        }
        SqlTools.validateDateFormat(format);
        ArrayList<DateTime> dates = new ArrayList<DateTime>();
        for (int i = 0; i < arr.length(); ++i) {
            String dateStr = arr.getString(i);
            try {
                DateTime date = DateUtil.parse((CharSequence)dateStr);
                dates.add(date);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef: " + dateStr + ", \u652f\u6301\u683c\u5f0f yyyy-MM-dd \u6216 yyyy-MM-dd HH:mm:ss", e);
            }
        }
        Date minDate = (Date)Collections.min(dates);
        Date maxDate = (Date)Collections.max(dates);
        LinkedHashSet<String> dateSequence = SqlTools.generateDateSequence(minDate, maxDate, format);
        StringBuilder result = new StringBuilder();
        if (wrapOuter) {
            result.append("select * from (\n");
        }
        int index = 0;
        for (String formattedDate : dateSequence) {
            String subQuery = sql.replace(PLACEHOLDER, formattedDate);
            result.append(subQuery);
            if (index < dateSequence.size() - 1) {
                result.append("\nunion all\n");
            }
            ++index;
        }
        if (wrapOuter) {
            result.append("\n) t");
        }
        return result.toString();
    }

    public static String renderUnionSqlForDate(List<String> arr, String sql, String format) {
        return SqlTools.renderUnionSqlForDate(arr, sql, format, true);
    }

    public static String renderUnionSqlForDate(List<String> arr, String sql, String format, boolean wrapOuter) {
        SqlTools.validateArrayParam(arr);
        JSONArray jsonArray = new JSONArray(arr);
        return SqlTools.renderUnionSqlForDateInternal(jsonArray, sql, format, wrapOuter);
    }

    private static LinkedHashSet<String> generateDateSequence(Date minDate, Date maxDate, String format) {
        LinkedHashSet<String> sequence = new LinkedHashSet<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String maxFormatted = sdf.format(maxDate);
        DateField incrementUnit = switch (format) {
            case FORMAT_YEAR -> DateField.YEAR;
            case FORMAT_MONTH -> DateField.MONTH;
            case FORMAT_DAY -> DateField.DAY_OF_MONTH;
            default -> throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f: " + format);
        };
        Date current = minDate;
        while (true) {
            String formatted = sdf.format(current);
            sequence.add(formatted);
            if (formatted.compareTo(maxFormatted) >= 0) break;
            current = DateUtil.offset((Date)current, (DateField)incrementUnit, (int)1);
        }
        return sequence;
    }
}

