package com.af.v4.system.common.plugins.calculate;

import com.af.v4.system.common.plugins.core.PriceFormatTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class StairpriceSettlement implements ISettlementInterface {

    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        return calcChargeInternal(chargeInfo, gas, 4);
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        return calcAmountInternal(chargeInfo, fee, 4);
    }

    @Override
    public JSONObject calcCharge2(JSONArray chargeInfo, BigDecimal gas) {
        return calcChargeInternal(chargeInfo, gas, 2);
    }

    @Override
    public JSONObject calcAmount2(JSONArray chargeInfo, BigDecimal fee) {
        return calcAmountInternal(chargeInfo, fee, 2);
    }

    // 内部通用方法，便于复用
    private JSONObject calcChargeInternal(JSONArray chargeInfo, BigDecimal gas, int scale) {
        int length = chargeInfo.length();

        BigDecimal sumamont = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
                .get("sumamount")));

        BigDecimal allamount = sumamont.add(gas);

        BigDecimal[] stairPrice = new BigDecimal[length - 1];
        BigDecimal[] stairAmount = new BigDecimal[length - 2];
        BigDecimal[] stairFee = new BigDecimal[length - 1];
        BigDecimal[] stairNum = new BigDecimal[length - 1];
        BigDecimal[] stairSurplus = new BigDecimal[length - 2];

        for (int i = 0; i < length - 1; i++) {
            stairPrice[i] = new BigDecimal("0");
            stairFee[i] = new BigDecimal("0");
            stairNum[i] = new BigDecimal("0");
        }

        for (int i = 0; i < length - 2; i++) {
            stairAmount[i] = new BigDecimal("0");
            stairSurplus[i] = new BigDecimal("0");
        }

        int start = 0;
        int end = 0;
        int i = 0;
        for (; i < length - 2; i++) {
            stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));
            stairAmount[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("amount")));

            if (allamount.compareTo(sumamont) > 0) {
                if (sumamont.compareTo(stairAmount[i]) >= 0) {
                    start = i + 1;
                }

                if (allamount.compareTo(stairAmount[i]) > 0) {
                    end = i + 1;
                }
            } else {
                if (allamount.compareTo(stairAmount[i]) >= 0) {
                    start = i + 1;
                }

                if (sumamont.compareTo(stairAmount[i]) >= 0) {
                    end = i + 1;
                }
            }

        }

        stairPrice[i] = new BigDecimal(String.valueOf(
                chargeInfo.getJSONObject(i).get("price")));

        if (gas.compareTo(BigDecimal.ZERO) > 0) {
            if (start == end) {
                stairNum[start] = gas;
                stairFee[start] = gas.multiply(stairPrice[start]).setScale(scale, RoundingMode.HALF_UP);
            } else {
                stairNum[start] = stairAmount[start].subtract(sumamont);
                stairFee[start] = stairNum[start].multiply(stairPrice[start])
                        .setScale(scale, RoundingMode.HALF_UP);

                for (i = start + 1; i < end; i++) {
                    stairNum[i] = stairAmount[i].subtract(stairAmount[(i - 1)]);
                    stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
                            scale, RoundingMode.HALF_UP);
                }
                stairNum[end] = allamount.subtract(stairAmount[(end - 1)]);
                stairFee[end] = stairNum[end].multiply(stairPrice[end])
                        .setScale(scale, RoundingMode.HALF_UP);
            }
        } else {
            if (start == end) {
                stairNum[start] = gas;
                stairFee[start] = gas.multiply(stairPrice[start]).setScale(scale, RoundingMode.HALF_UP);
            } else {
                stairNum[start] = allamount.subtract(stairAmount[start]);
                stairFee[start] = stairNum[start].multiply(stairPrice[start])
                        .setScale(scale, RoundingMode.HALF_UP);

                for (i = start + 1; i < end; i++) {
                    stairNum[i] = stairAmount[i - 1].subtract(stairAmount[i]);
                    stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
                            scale, RoundingMode.HALF_UP);
                }

                stairNum[end] = stairAmount[(end - 1)].subtract(sumamont);
                stairFee[end] = stairNum[end].multiply(stairPrice[end])
                        .setScale(scale, RoundingMode.HALF_UP);
            }
        }

        JSONObject ret = new JSONObject();
        BigDecimal chargenum = new BigDecimal("0");
        BigDecimal oughtamount = new BigDecimal("0");

        JSONArray array = new JSONArray();
        for (i = 0; i < length - 1; i++) {
            chargenum = chargenum.add(stairFee[i]);
            oughtamount = oughtamount.add(stairNum[i]);
            ret.put(STR."f_stair\{i + 1}fee", stairFee[i]);
            ret.put(STR."f_stair\{i + 1}amount", stairNum[i]);
            ret.put(STR."f_stair\{i + 1}price", stairPrice[i]);

            JSONObject json = new JSONObject();
            json.put("f_price_name", STR."阶梯\{i + 1}");
            json.put("f_price", stairPrice[i]);
            json.put("f_gas", stairNum[i]);
            json.put("f_money", stairFee[i]);
            array.put(json);
        }

        for (i = 0; i < stairAmount.length; i++) {
            ret.put(STR."f_stair\{i + 1}ceiling", stairAmount[i]);
        }

        for (i = 0; i < length - 2; i++) {
            if (allamount.compareTo(stairAmount[i]) < 0) {
                for (int j = 0; j < i; j++) {
                    stairSurplus[j] = BigDecimal.ZERO;
                    ret.put(STR."f_stair\{j + 1}surplus", stairSurplus[j]);
                }

                stairSurplus[i] = stairAmount[i].subtract(allamount);
                ret.put(STR."f_stair\{i + 1}surplus", stairSurplus[i]);
                for (int j = i + 1; j < length - 2; j++) {
                    stairSurplus[j] = stairAmount[j]
                            .subtract(stairAmount[(j - 1)]);

                    ret.put(STR."f_stair\{j + 1}surplus", stairSurplus[j]);
                }

                break;
            }
        }
        ret.put("chargenum", chargenum);
        ret.put("oughtamount", oughtamount);
        ret.put("sumamount", sumamont);
        ret.put("chargeprice", array);

        // 根据小数位数选择格式化方式
        if (scale == 2) {
            PriceFormatTools.formatNumberTwoDecimal(ret,"f_price");
        } else {
            PriceFormatTools.formatNumber(ret, "f_price");
        }
        return ret;
    }

    private JSONObject calcAmountInternal(JSONArray chargeInfo, BigDecimal fee, int scale) {
        int length = chargeInfo.length();

        BigDecimal sumamont = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
                .get("sumamount")));
        BigDecimal sumamont1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
                .get("sumamount")));

        BigDecimal[] stairPrice = new BigDecimal[length - 1];
        BigDecimal[] stairAmount = new BigDecimal[length - 2];
        BigDecimal[] stairFee = new BigDecimal[length - 1];
        BigDecimal[] stairNum = new BigDecimal[length - 1];
        BigDecimal[] stairSurplus = new BigDecimal[length - 2];

        JSONObject ret = new JSONObject();
        BigDecimal chargenum = new BigDecimal("0");
        BigDecimal oughtamount = new BigDecimal("0");

        for (int i = 0; i < length - 1; i++) {
            stairPrice[i] = new BigDecimal("0");
            stairFee[i] = new BigDecimal("0");
            stairNum[i] = new BigDecimal("0");
        }

        for (int i = 0; i < length - 2; i++) {
            stairAmount[i] = new BigDecimal("0");
            stairSurplus[i] = new BigDecimal("0");
        }

        int start = 0;
        int i = 0;
        for (; i < length - 2; i++) {
            stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));
            stairAmount[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("amount")));

            if (sumamont.compareTo(stairAmount[i]) >= 0) {
                start = i + 1;
            }
        }

        stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));

        for (i = start; i < stairAmount.length; i++) {
            if (stairAmount[i].subtract(sumamont).multiply(stairPrice[i])
                    .compareTo(fee) >= 0) {
                stairNum[i] = fee.divide(stairPrice[i], scale, RoundingMode.HALF_UP);

                stairFee[i] = stairNum[i].multiply(stairPrice[i])
                        .setScale(scale, RoundingMode.HALF_UP);

                for (int j = 0; j < i; j++) {
                    stairSurplus[j] = BigDecimal.ZERO;
                    ret.put(STR."f_stair\{j + 1}surplus", stairSurplus[j]);
                }

                stairSurplus[i] = stairAmount[i].subtract(stairNum[i])
                        .subtract(sumamont);

                ret.put(STR."f_stair\{i + 1}surplus", stairSurplus[i]);

                for (int j = i + 1; j < stairAmount.length; j++) {
                    stairSurplus[j] = stairAmount[j]
                            .subtract(stairAmount[(j - 1)]);

                    ret.put(STR."f_stair\{j + 1}surplus", stairSurplus[j]);
                }

                break;
            }
            stairNum[i] = stairAmount[i].subtract(sumamont);
            stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(scale, RoundingMode.HALF_UP);

            fee = fee.subtract(stairFee[i]);
            sumamont = stairAmount[i];
        }

        stairNum[i] = fee.divide(stairPrice[i], scale, RoundingMode.HALF_UP);
        stairFee[i] = fee;

        JSONArray array = new JSONArray();
        for (i = 0; i < length - 1; i++) {
            chargenum = chargenum.add(stairFee[i]);
            oughtamount = oughtamount.add(stairNum[i]);
            ret.put(STR."f_stair\{i + 1}fee", stairFee[i]);
            ret.put(STR."f_stair\{i + 1}amount", stairNum[i]);
            ret.put(STR."f_stair\{i + 1}price", stairPrice[i]);

            JSONObject json = new JSONObject();
            json.put("f_price_name", STR."阶梯\{i + 1}");
            json.put("f_price", stairPrice[i]);
            json.put("f_gas", stairNum[i]);
            json.put("f_money", stairFee[i]);
            array.put(json);
        }

        for (i = 0; i < stairAmount.length; i++) {
            ret.put(STR."f_stair\{i + 1}ceiling", stairAmount[i]);
        }
        int j;
        try {
            ret.get("f_stair1surplus");
        } catch (Exception ignored) {
        }
        for (j = 0; j < stairSurplus.length; j++) {
            //stairSurplus[j] = BigDecimal.ZERO;
            ret.put(STR."f_stair\{j + 1}surplus", stairSurplus[j]);
        }

        ret.put("chargenum", chargenum);
        ret.put("sumamount", sumamont1);
        ret.put("gas", oughtamount);
        ret.put("chargeprice", array);

        // 根据小数位数选择格式化方式
        if (scale == 2) {
            PriceFormatTools.formatNumberTwoDecimal(ret,"f_price");
        } else {
            PriceFormatTools.formatNumber(ret,"f_price");
        }
        return ret;
    }
}
