/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.security;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Set;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveDataEnhancer {
    private static final Logger log = LoggerFactory.getLogger(SensitiveDataEnhancer.class);
    public static final String AES_KEY = "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt";
    private static final String AES_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final Pattern DIGITS_ONLY_PATTERN = Pattern.compile("\\D");
    private static final Pattern PHONE_FORMAT_PATTERN = Pattern.compile("\\d+");
    private static final Pattern ID_NUMBER_PATTERN = Pattern.compile("\\d{6}\\d{8}[\\dXx]");
    private static final Set<String> NAME_STRATEGIES = Set.of("name", "\u59d3\u540d", "\u7528\u6237\u540d", "username", "realname", "nickname");
    private static final Set<String> PHONE_STRATEGIES = Set.of("phone", "mobile", "\u624b\u673a", "\u7535\u8bdd", "tel", "telephone");
    private static final Set<String> ADDRESS_STRATEGIES = Set.of("address", "addr", "\u5730\u5740", "\u4f4f\u5740", "location");
    private static final Set<String> ID_STRATEGIES = Set.of("idnumber", "idcard", "\u8eab\u4efd\u8bc1", "\u8bc1\u4ef6\u53f7", "cardnumber");

    public static String applyMaskingStrategy(String fieldName, String originalValue, String strategy) {
        if (originalValue == null || originalValue.isEmpty()) {
            return originalValue;
        }
        String actualStrategy = strategy != null ? strategy : SensitiveDataEnhancer.inferStrategy(fieldName);
        try {
            return switch (actualStrategy.toLowerCase()) {
                case "name" -> SensitiveDataEnhancer.maskUserName(originalValue);
                case "phone", "mobile" -> SensitiveDataEnhancer.maskPhone(originalValue);
                case "address", "addr" -> SensitiveDataEnhancer.maskAddress(originalValue);
                case "idnumber", "idcard" -> SensitiveDataEnhancer.maskIdNumber(originalValue);
                default -> SensitiveDataEnhancer.maskDefault(originalValue);
            };
        }
        catch (Exception e) {
            log.error("\u8131\u654f\u5904\u7406\u5931\u8d25: {}, \u7b56\u7565: {}", new Object[]{fieldName, actualStrategy, e});
            return "**MASKED**";
        }
    }

    public static String inferStrategy(String fieldName) {
        String lower = fieldName.toLowerCase();
        if (NAME_STRATEGIES.stream().anyMatch(lower::contains)) {
            return "name";
        }
        if (PHONE_STRATEGIES.stream().anyMatch(lower::contains)) {
            return "phone";
        }
        if (ADDRESS_STRATEGIES.stream().anyMatch(lower::contains)) {
            return "address";
        }
        if (ID_STRATEGIES.stream().anyMatch(lower::contains)) {
            return "idnumber";
        }
        return "default";
    }

    private static String maskUserName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        int length = name.length();
        return switch (length) {
            case 1 -> name;
            case 2 -> "*" + name.charAt(1);
            default -> name.charAt(0) + "*".repeat(length - 2) + name.charAt(length - 1);
        };
    }

    private static String maskPhone(String phone) {
        if (phone == null || phone.isEmpty()) {
            return phone;
        }
        String digitsOnly = DIGITS_ONLY_PATTERN.matcher(phone).replaceAll("");
        int length = digitsOnly.length();
        if (length < 4) {
            return phone;
        }
        return switch (length) {
            case 4, 5, 6, 7 -> {
                String prefix = digitsOnly.substring(0, 2);
                String suffix = digitsOnly.substring(length - 1);
                yield PHONE_FORMAT_PATTERN.matcher(phone).replaceAll(prefix + "*".repeat(length - 3) + suffix);
            }
            case 8, 9, 10, 11 -> {
                String prefix = digitsOnly.substring(0, 3);
                String suffix = digitsOnly.substring(length - 2);
                yield PHONE_FORMAT_PATTERN.matcher(phone).replaceAll(prefix + "****" + suffix);
            }
            default -> {
                String prefix = digitsOnly.substring(0, 3);
                String suffix = digitsOnly.substring(length - 4);
                yield PHONE_FORMAT_PATTERN.matcher(phone).replaceAll(prefix + "****" + suffix);
            }
        };
    }

    private static String maskIdNumber(String idNumber) {
        if (idNumber == null || idNumber.isEmpty()) {
            return idNumber;
        }
        return switch (idNumber.length()) {
            case 15 -> idNumber.substring(0, 6) + "*".repeat(6) + idNumber.substring(12);
            case 18 -> {
                if (ID_NUMBER_PATTERN.matcher(idNumber).matches()) {
                    yield idNumber.substring(0, 6) + "*".repeat(8) + idNumber.substring(14);
                }
                yield idNumber.substring(0, 6) + "*".repeat(8) + idNumber.substring(14);
            }
            default -> idNumber.length() >= 10 ? idNumber.substring(0, 6) + "*".repeat(Math.min(8, idNumber.length() - 10)) + idNumber.substring(Math.max(6, idNumber.length() - 4)) : idNumber;
        };
    }

    private static String maskAddress(String address) {
        if (address == null || address.isEmpty()) {
            return address;
        }
        int length = address.length();
        return switch (length) {
            case 1, 2, 3 -> address;
            case 4, 5, 6 -> address.substring(0, 2) + "***";
            case 7, 8, 9, 10 -> address.substring(0, 3) + "***" + address.substring(length - 2);
            default -> address.substring(0, 4) + "***" + address.substring(length - 3);
        };
    }

    private static String maskDefault(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int length = value.length();
        return switch (length) {
            case 1, 2 -> "*".repeat(length);
            case 3, 4, 5, 6 -> value.charAt(0) + "*".repeat(length - 2) + value.charAt(length - 1);
            default -> value.substring(0, 2) + "*".repeat(length - 4) + value.substring(length - 2);
        };
    }

    private static boolean isNullOrBlank(String input) {
        return input == null || input.isBlank();
    }

    public static String aesEncrypt(String input) throws Exception {
        if (SensitiveDataEnhancer.isNullOrBlank(input)) {
            return null;
        }
        SecretKeySpec keySpec = new SecretKeySpec(AES_KEY.getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(1, keySpec);
        byte[] encryptedBytes = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String aesDecrypt(String encrypted) throws Exception {
        if (SensitiveDataEnhancer.isNullOrBlank(encrypted)) {
            return null;
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(AES_KEY.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(2, keySpec);
            byte[] encryptedBytes = Base64.getDecoder().decode(encrypted);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("AES\u89e3\u5bc6\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u6570\u636e\u683c\u5f0f\u9519\u8bef\u6216\u5bc6\u94a5\u4e0d\u5339\u914d", (Throwable)e);
            throw e;
        }
    }
}

