/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core;

import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import com.af.v4.system.common.plugins.http.config.HttpLogSuppressor;
import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.core.response.DefaultAsyncResponse;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAsyncConnectionPoolUtil
extends BaseHttpPoolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAsyncConnectionPoolUtil.class);
    private static final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private static volatile CloseableHttpAsyncClient httpClient;

    public static CloseableHttpAsyncClient getHttpClient(TlsStrategy sslSocketFactory) {
        return HttpAsyncConnectionPoolUtil.createHttpClient(sslSocketFactory);
    }

    private static CloseableHttpAsyncClient createHttpClient() {
        return HttpAsyncConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpAsyncClient createHttpClient(TlsStrategy sslSocketFactory) {
        HttpClientConfig config = new HttpClientConfig.Builder().build();
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = new DefaultClientTlsStrategy(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        Registry registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).build();
        PoolingAsyncClientConnectionManager manager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy((TlsStrategy)registry.lookup("https")).build();
        manager.setMaxTotal(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        manager.setDefaultMaxPerRoute(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).build();
        manager.setDefaultConnectionConfig(connectionConfig);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).setResponseTimeout(Timeout.ofSeconds((long)config.getSocketTimeout().intValue())).build();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 2 + 1).setSoKeepAlive(true).build();
        return HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).setConnectionManager((AsyncClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).build();
    }

    public static CloseableHttpAsyncClient getHttpClient() {
        if (httpClient == null) {
            SYNC_LOCK.lock();
            try {
                if (httpClient == null) {
                    httpClient = HttpAsyncConnectionPoolUtil.createHttpClient();
                }
            }
            finally {
                SYNC_LOCK.unlock();
            }
        }
        httpClient.start();
        return httpClient;
    }

    public static void request(String value, String headersStr, HttpClientConfig config, SimpleHttpRequest base, CloseableHttpAsyncClient httpClient, FutureCallback<SimpleHttpResponse> futureCallback) {
        if (httpClient == null) {
            httpClient = HttpAsyncConnectionPoolUtil.getHttpClient();
        }
        if (futureCallback == null) {
            futureCallback = new DefaultAsyncResponse();
        }
        HttpAsyncConnectionPoolUtil.setHeaders((HttpRequest)base, headersStr);
        if (base.getBody() == null) {
            HttpAsyncConnectionPoolUtil.setBody((HttpRequest)base, value);
        }
        httpClient.execute(base, (FutureCallback)futureCallback);
        String url = base.getScheme() + "://" + String.valueOf(base.getAuthority()) + base.getPath();
        if (!HttpLogSuppressor.isEnabled()) {
            LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0ctype: async", new Object[]{url, headersStr, value});
        }
    }
}

