/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstitutionCipherUtil {
    private static final Logger log = LoggerFactory.getLogger(SubstitutionCipherUtil.class);
    private static final String DEFAULT_CIPHER_TABLE_PATH = "cipher_table.json";
    private static final int CIPHER_LENGTH = 4;
    private static volatile Map<String, String> encryptMap;
    private static volatile Map<String, String> decryptMap;
    private static final ReentrantReadWriteLock lock;
    private static volatile boolean initialized;
    private static final ObjectMapper objectMapper;

    private SubstitutionCipherUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void init(String passwordTablePath) {
        lock.writeLock().lock();
        try {
            Map loadedMap;
            log.info("\u5f00\u59cb\u521d\u59cb\u5316\u5bc6\u7801\u8868\uff0c\u8def\u5f84: {}", (Object)passwordTablePath);
            InputStream inputStream = SubstitutionCipherUtil.class.getClassLoader().getResourceAsStream(passwordTablePath);
            if (inputStream == null) {
                throw new RuntimeException("\u5bc6\u7801\u8868\u6587\u4ef6\u4e0d\u5b58\u5728: " + passwordTablePath);
            }
            try {
                loadedMap = (Map)objectMapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                throw new RuntimeException("\u5bc6\u7801\u8868\u6587\u4ef6\u683c\u5f0f\u9519\u8bef: " + passwordTablePath, e);
            }
            if (loadedMap == null || loadedMap.isEmpty()) {
                throw new RuntimeException("\u5bc6\u7801\u8868\u6587\u4ef6\u4e3a\u7a7a: " + passwordTablePath);
            }
            SubstitutionCipherUtil.validateCipherTable(loadedMap);
            encryptMap = Map.copyOf(loadedMap);
            HashMap<String, String> reverseMap = new HashMap<String, String>(loadedMap.size());
            for (Map.Entry entry : loadedMap.entrySet()) {
                String plaintext = (String)entry.getKey();
                String ciphertext = (String)entry.getValue();
                if (reverseMap.containsKey(ciphertext)) {
                    throw new RuntimeException(String.format("\u5bc6\u7801\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5bc6\u6587: %s \u5bf9\u5e94\u591a\u4e2a\u660e\u6587: %s \u548c %s", ciphertext, reverseMap.get(ciphertext), plaintext));
                }
                reverseMap.put(ciphertext, plaintext);
            }
            decryptMap = Collections.unmodifiableMap(reverseMap);
            initialized = true;
            log.info("\u5bc6\u7801\u8868\u521d\u59cb\u5316\u6210\u529f\uff0c\u52a0\u8f7d {} \u4e2a\u6620\u5c04", (Object)encryptMap.size());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bc6\u7801\u8868\u521d\u59cb\u5316\u5931\u8d25: " + passwordTablePath, e);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static void validateCipherTable(Map<String, String> cipherTable) {
        for (Map.Entry<String, String> entry : cipherTable.entrySet()) {
            String plaintext = entry.getKey();
            String ciphertext = entry.getValue();
            if (plaintext == null || plaintext.isEmpty()) {
                throw new RuntimeException("\u5bc6\u7801\u8868\u4e2d\u5b58\u5728\u7a7a\u7684\u660e\u6587\u952e");
            }
            if (ciphertext == null || ciphertext.length() != 4) {
                throw new RuntimeException(String.format("\u5bc6\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u660e\u6587 '%s' \u7684\u5bc6\u6587 '%s' \u957f\u5ea6\u4e0d\u4e3a %d", plaintext, ciphertext, 4));
            }
            char firstChar = ciphertext.charAt(0);
            if (firstChar < 'a' || firstChar > 'z') {
                throw new RuntimeException(String.format("\u5bc6\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u660e\u6587 '%s' \u7684\u5bc6\u6587 '%s' \u7b2c\u4e00\u4f4d\u4e0d\u662f\u5c0f\u5199\u5b57\u6bcd", plaintext, ciphertext));
            }
            for (int i = 1; i < 4; ++i) {
                char c = ciphertext.charAt(i);
                if (Character.isLetterOrDigit(c)) continue;
                throw new RuntimeException(String.format("\u5bc6\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u660e\u6587 '%s' \u7684\u5bc6\u6587 '%s' \u7b2c %d \u4f4d\u4e0d\u662f\u5b57\u6bcd\u6216\u6570\u5b57", plaintext, ciphertext, i + 1));
            }
        }
    }

    private static void checkInitialized() {
        if (!initialized) {
            throw new IllegalStateException("\u5bc6\u7801\u8868\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 init() \u65b9\u6cd5");
        }
    }

    public static String encrypt(String plaintext) {
        if (plaintext == null) {
            log.warn("\u660e\u6587\u4e0d\u80fd\u4e3a null");
            return null;
        }
        SubstitutionCipherUtil.checkInitialized();
        if (plaintext.isEmpty()) {
            return plaintext;
        }
        StringBuilder result = new StringBuilder(plaintext.length() * 4);
        for (int i = 0; i < plaintext.length(); ++i) {
            String character = String.valueOf(plaintext.charAt(i));
            String cipher = encryptMap.get(character);
            result.append(Objects.requireNonNullElse(cipher, character));
        }
        return result.toString();
    }

    public static String decrypt(String ciphertext) {
        if (ciphertext == null) {
            throw new IllegalArgumentException("\u5bc6\u6587\u4e0d\u80fd\u4e3a null");
        }
        SubstitutionCipherUtil.checkInitialized();
        if (ciphertext.isEmpty()) {
            return ciphertext;
        }
        StringBuilder result = new StringBuilder(ciphertext.length());
        int i = 0;
        while (i < ciphertext.length()) {
            String cipherUnit;
            String plainChar;
            if (i + 4 <= ciphertext.length() && (plainChar = decryptMap.get(cipherUnit = ciphertext.substring(i, i + 4))) != null) {
                result.append(plainChar);
                i += 4;
                continue;
            }
            result.append(ciphertext.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public static boolean equalsCipher(String newPlain, String existingCipher) {
        if (newPlain == null && (existingCipher == null || existingCipher.isEmpty())) {
            return true;
        }
        if (newPlain == null) {
            return false;
        }
        String newCipher = SubstitutionCipherUtil.encrypt(newPlain);
        return Objects.equals(newCipher, existingCipher);
    }

    public static boolean hasCipherChanged(String newPlain, String existingCipher) {
        return !SubstitutionCipherUtil.equalsCipher(newPlain, existingCipher);
    }

    public static Map<String, String> getEncryptMap() {
        SubstitutionCipherUtil.checkInitialized();
        return encryptMap;
    }

    public static Map<String, String> getDecryptMap() {
        SubstitutionCipherUtil.checkInitialized();
        return decryptMap;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static int getCipherLength() {
        return 4;
    }

    static {
        lock = new ReentrantReadWriteLock();
        initialized = false;
        objectMapper = new ObjectMapper();
        try {
            SubstitutionCipherUtil.init(DEFAULT_CIPHER_TABLE_PATH);
        }
        catch (Exception e) {
            log.error("\u4f7f\u7528\u9ed8\u8ba4\u8def\u5f84\u52a0\u8f7d\u5bc6\u7801\u8868\u5931\u8d25: {}", (Object)DEFAULT_CIPHER_TABLE_PATH, (Object)e);
        }
    }
}

