package com.af.v4.system.common.plugins.http.config;

import org.json.JSONObject;

/**
 * HttpClient配置文件
 *
 * @author Mr.river
 */
public class HttpClientConfig {
    /**
     * 连接池最大连接数
     */
    public static final Integer HTTP_MAX_POOL_SIZE = 256;
    /**
     * 持久连接在连接池中保持活动状态时可以保持空闲的最长时间。
     * 不活动时间超过此值的连接将被关闭并从池中逐出
     */
    public static final Integer HTTP_IDEL_TIME_OUT = 5000;
    /**
     * 请求连接超时时间
     */
    private final Integer connectTimeout;
    /**
     * 请求socket超时时间
     */
    private final Integer socketTimeout;

    private HttpClientConfig(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
    }

    private static HttpClientConfig create(Builder builder) {
        return new HttpClientConfig(builder);
    }

    public Integer getConnectTimeout() {
        return connectTimeout;
    }

    public Integer getSocketTimeout() {
        return socketTimeout;
    }

    public static class Builder {
        private Integer connectTimeout = 5000;

        private Integer socketTimeout = 20000;

        public Builder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public HttpClientConfig build() {
            return create(this);
        }

        public HttpClientConfig build(JSONObject config) {
            if (config.has("connectTimeOut")) {
                this.connectTimeout = config.getInt("connectTimeOut");
            }
            if (config.has("socketTimeout")) {
                this.socketTimeout = config.getInt("socketTimeout");
            }
            return create(this);
        }
    }
}
